package zio.aws.kendra.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class AdditionalResultAttribute(
    key: String,
    valueType: zio.aws.kendra.model.AdditionalResultAttributeValueType,
    value: zio.aws.kendra.model.AdditionalResultAttributeValue
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kendra.model.AdditionalResultAttribute = {
    import AdditionalResultAttribute.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kendra.model.AdditionalResultAttribute
      .builder()
      .key(key: java.lang.String)
      .valueType(valueType.unwrap)
      .value(value.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.kendra.model.AdditionalResultAttribute.ReadOnly =
    zio.aws.kendra.model.AdditionalResultAttribute.wrap(buildAwsValue())
}
object AdditionalResultAttribute {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kendra.model.AdditionalResultAttribute
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kendra.model.AdditionalResultAttribute =
      zio.aws.kendra.model
        .AdditionalResultAttribute(key, valueType, value.asEditable)
    def key: String
    def valueType: zio.aws.kendra.model.AdditionalResultAttributeValueType
    def value: zio.aws.kendra.model.AdditionalResultAttributeValue.ReadOnly
    def getKey: ZIO[Any, Nothing, String] = ZIO.succeed(key)
    def getValueType: ZIO[
      Any,
      Nothing,
      zio.aws.kendra.model.AdditionalResultAttributeValueType
    ] = ZIO.succeed(valueType)
    def getValue: ZIO[
      Any,
      Nothing,
      zio.aws.kendra.model.AdditionalResultAttributeValue.ReadOnly
    ] = ZIO.succeed(value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kendra.model.AdditionalResultAttribute
  ) extends zio.aws.kendra.model.AdditionalResultAttribute.ReadOnly {
    override val key: String = impl.key(): String
    override val valueType
        : zio.aws.kendra.model.AdditionalResultAttributeValueType =
      zio.aws.kendra.model.AdditionalResultAttributeValueType
        .wrap(impl.valueType())
    override val value
        : zio.aws.kendra.model.AdditionalResultAttributeValue.ReadOnly =
      zio.aws.kendra.model.AdditionalResultAttributeValue.wrap(impl.value())
  }
  def wrap(
      impl: software.amazon.awssdk.services.kendra.model.AdditionalResultAttribute
  ): zio.aws.kendra.model.AdditionalResultAttribute.ReadOnly = new Wrapper(impl)
}
