package zio.aws.kendra.model
import zio.ZIO
import zio.aws.kendra.model.primitives.{IndexId, ExperienceId}
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class AssociatePersonasToEntitiesRequest(
    id: ExperienceId,
    indexId: IndexId,
    personas: Iterable[zio.aws.kendra.model.EntityPersonaConfiguration]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kendra.model.AssociatePersonasToEntitiesRequest = {
    import AssociatePersonasToEntitiesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kendra.model.AssociatePersonasToEntitiesRequest
      .builder()
      .id(ExperienceId.unwrap(id): java.lang.String)
      .indexId(IndexId.unwrap(indexId): java.lang.String)
      .personas(personas.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.kendra.model.AssociatePersonasToEntitiesRequest.ReadOnly =
    zio.aws.kendra.model.AssociatePersonasToEntitiesRequest
      .wrap(buildAwsValue())
}
object AssociatePersonasToEntitiesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kendra.model.AssociatePersonasToEntitiesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kendra.model.AssociatePersonasToEntitiesRequest =
      zio.aws.kendra.model.AssociatePersonasToEntitiesRequest(
        id,
        indexId,
        personas.map { item =>
          item.asEditable
        }
      )
    def id: ExperienceId
    def indexId: IndexId
    def personas: List[zio.aws.kendra.model.EntityPersonaConfiguration.ReadOnly]
    def getId: ZIO[Any, Nothing, ExperienceId] = ZIO.succeed(id)
    def getIndexId: ZIO[Any, Nothing, IndexId] = ZIO.succeed(indexId)
    def getPersonas: ZIO[Any, Nothing, List[
      zio.aws.kendra.model.EntityPersonaConfiguration.ReadOnly
    ]] = ZIO.succeed(personas)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kendra.model.AssociatePersonasToEntitiesRequest
  ) extends zio.aws.kendra.model.AssociatePersonasToEntitiesRequest.ReadOnly {
    override val id: ExperienceId =
      zio.aws.kendra.model.primitives.ExperienceId(impl.id())
    override val indexId: IndexId =
      zio.aws.kendra.model.primitives.IndexId(impl.indexId())
    override val personas
        : List[zio.aws.kendra.model.EntityPersonaConfiguration.ReadOnly] = impl
      .personas()
      .asScala
      .map { item =>
        zio.aws.kendra.model.EntityPersonaConfiguration.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.kendra.model.AssociatePersonasToEntitiesRequest
  ): zio.aws.kendra.model.AssociatePersonasToEntitiesRequest.ReadOnly =
    new Wrapper(impl)
}
