package zio.aws.kendra.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AttributeFilter(
    andAllFilters: Optional[Iterable[zio.aws.kendra.model.AttributeFilter]] =
      Optional.Absent,
    orAllFilters: Optional[Iterable[zio.aws.kendra.model.AttributeFilter]] =
      Optional.Absent,
    notFilter: Optional[zio.aws.kendra.model.AttributeFilter] = Optional.Absent,
    equalsTo: Optional[zio.aws.kendra.model.DocumentAttribute] =
      Optional.Absent,
    containsAll: Optional[zio.aws.kendra.model.DocumentAttribute] =
      Optional.Absent,
    containsAny: Optional[zio.aws.kendra.model.DocumentAttribute] =
      Optional.Absent,
    greaterThan: Optional[zio.aws.kendra.model.DocumentAttribute] =
      Optional.Absent,
    greaterThanOrEquals: Optional[zio.aws.kendra.model.DocumentAttribute] =
      Optional.Absent,
    lessThan: Optional[zio.aws.kendra.model.DocumentAttribute] =
      Optional.Absent,
    lessThanOrEquals: Optional[zio.aws.kendra.model.DocumentAttribute] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kendra.model.AttributeFilter = {
    import AttributeFilter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kendra.model.AttributeFilter
      .builder()
      .optionallyWith(
        andAllFilters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.andAllFilters)
      .optionallyWith(
        orAllFilters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.orAllFilters)
      .optionallyWith(notFilter.map(value => value.buildAwsValue()))(
        _.notFilter
      )
      .optionallyWith(equalsTo.map(value => value.buildAwsValue()))(_.equalsTo)
      .optionallyWith(containsAll.map(value => value.buildAwsValue()))(
        _.containsAll
      )
      .optionallyWith(containsAny.map(value => value.buildAwsValue()))(
        _.containsAny
      )
      .optionallyWith(greaterThan.map(value => value.buildAwsValue()))(
        _.greaterThan
      )
      .optionallyWith(greaterThanOrEquals.map(value => value.buildAwsValue()))(
        _.greaterThanOrEquals
      )
      .optionallyWith(lessThan.map(value => value.buildAwsValue()))(_.lessThan)
      .optionallyWith(lessThanOrEquals.map(value => value.buildAwsValue()))(
        _.lessThanOrEquals
      )
      .build()
  }
  def asReadOnly: zio.aws.kendra.model.AttributeFilter.ReadOnly =
    zio.aws.kendra.model.AttributeFilter.wrap(buildAwsValue())
}
object AttributeFilter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kendra.model.AttributeFilter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kendra.model.AttributeFilter =
      zio.aws.kendra.model.AttributeFilter(
        andAllFilters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        orAllFilters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        notFilter.map(value => value.asEditable),
        equalsTo.map(value => value.asEditable),
        containsAll.map(value => value.asEditable),
        containsAny.map(value => value.asEditable),
        greaterThan.map(value => value.asEditable),
        greaterThanOrEquals.map(value => value.asEditable),
        lessThan.map(value => value.asEditable),
        lessThanOrEquals.map(value => value.asEditable)
      )
    def andAllFilters
        : Optional[List[zio.aws.kendra.model.AttributeFilter.ReadOnly]]
    def orAllFilters
        : Optional[List[zio.aws.kendra.model.AttributeFilter.ReadOnly]]
    def notFilter: Optional[zio.aws.kendra.model.AttributeFilter.ReadOnly]
    def equalsTo: Optional[zio.aws.kendra.model.DocumentAttribute.ReadOnly]
    def containsAll: Optional[zio.aws.kendra.model.DocumentAttribute.ReadOnly]
    def containsAny: Optional[zio.aws.kendra.model.DocumentAttribute.ReadOnly]
    def greaterThan: Optional[zio.aws.kendra.model.DocumentAttribute.ReadOnly]
    def greaterThanOrEquals
        : Optional[zio.aws.kendra.model.DocumentAttribute.ReadOnly]
    def lessThan: Optional[zio.aws.kendra.model.DocumentAttribute.ReadOnly]
    def lessThanOrEquals
        : Optional[zio.aws.kendra.model.DocumentAttribute.ReadOnly]
    def getAndAllFilters: ZIO[Any, AwsError, List[
      zio.aws.kendra.model.AttributeFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("andAllFilters", andAllFilters)
    def getOrAllFilters: ZIO[Any, AwsError, List[
      zio.aws.kendra.model.AttributeFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("orAllFilters", orAllFilters)
    def getNotFilter
        : ZIO[Any, AwsError, zio.aws.kendra.model.AttributeFilter.ReadOnly] =
      AwsError.unwrapOptionField("notFilter", notFilter)
    def getEqualsTo
        : ZIO[Any, AwsError, zio.aws.kendra.model.DocumentAttribute.ReadOnly] =
      AwsError.unwrapOptionField("equalsTo", equalsTo)
    def getContainsAll
        : ZIO[Any, AwsError, zio.aws.kendra.model.DocumentAttribute.ReadOnly] =
      AwsError.unwrapOptionField("containsAll", containsAll)
    def getContainsAny
        : ZIO[Any, AwsError, zio.aws.kendra.model.DocumentAttribute.ReadOnly] =
      AwsError.unwrapOptionField("containsAny", containsAny)
    def getGreaterThan
        : ZIO[Any, AwsError, zio.aws.kendra.model.DocumentAttribute.ReadOnly] =
      AwsError.unwrapOptionField("greaterThan", greaterThan)
    def getGreaterThanOrEquals
        : ZIO[Any, AwsError, zio.aws.kendra.model.DocumentAttribute.ReadOnly] =
      AwsError.unwrapOptionField("greaterThanOrEquals", greaterThanOrEquals)
    def getLessThan
        : ZIO[Any, AwsError, zio.aws.kendra.model.DocumentAttribute.ReadOnly] =
      AwsError.unwrapOptionField("lessThan", lessThan)
    def getLessThanOrEquals
        : ZIO[Any, AwsError, zio.aws.kendra.model.DocumentAttribute.ReadOnly] =
      AwsError.unwrapOptionField("lessThanOrEquals", lessThanOrEquals)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kendra.model.AttributeFilter
  ) extends zio.aws.kendra.model.AttributeFilter.ReadOnly {
    override val andAllFilters
        : Optional[List[zio.aws.kendra.model.AttributeFilter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.andAllFilters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.kendra.model.AttributeFilter.wrap(item)
          }.toList
        )
    override val orAllFilters
        : Optional[List[zio.aws.kendra.model.AttributeFilter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.orAllFilters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.kendra.model.AttributeFilter.wrap(item)
          }.toList
        )
    override val notFilter
        : Optional[zio.aws.kendra.model.AttributeFilter.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.notFilter())
        .map(value => zio.aws.kendra.model.AttributeFilter.wrap(value))
    override val equalsTo
        : Optional[zio.aws.kendra.model.DocumentAttribute.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.equalsTo())
        .map(value => zio.aws.kendra.model.DocumentAttribute.wrap(value))
    override val containsAll
        : Optional[zio.aws.kendra.model.DocumentAttribute.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.containsAll())
        .map(value => zio.aws.kendra.model.DocumentAttribute.wrap(value))
    override val containsAny
        : Optional[zio.aws.kendra.model.DocumentAttribute.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.containsAny())
        .map(value => zio.aws.kendra.model.DocumentAttribute.wrap(value))
    override val greaterThan
        : Optional[zio.aws.kendra.model.DocumentAttribute.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.greaterThan())
        .map(value => zio.aws.kendra.model.DocumentAttribute.wrap(value))
    override val greaterThanOrEquals
        : Optional[zio.aws.kendra.model.DocumentAttribute.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.greaterThanOrEquals())
        .map(value => zio.aws.kendra.model.DocumentAttribute.wrap(value))
    override val lessThan
        : Optional[zio.aws.kendra.model.DocumentAttribute.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lessThan())
        .map(value => zio.aws.kendra.model.DocumentAttribute.wrap(value))
    override val lessThanOrEquals
        : Optional[zio.aws.kendra.model.DocumentAttribute.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lessThanOrEquals())
        .map(value => zio.aws.kendra.model.DocumentAttribute.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kendra.model.AttributeFilter
  ): zio.aws.kendra.model.AttributeFilter.ReadOnly = new Wrapper(impl)
}
