package zio.aws.kendra.model
import java.lang.Integer
import zio.ZIO
import zio.aws.kendra.model.primitives.{SecretArn, Port, Host}
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class BasicAuthenticationConfiguration(
    host: Host,
    port: Port,
    credentials: SecretArn
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kendra.model.BasicAuthenticationConfiguration = {
    import BasicAuthenticationConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kendra.model.BasicAuthenticationConfiguration
      .builder()
      .host(Host.unwrap(host): java.lang.String)
      .port(Port.unwrap(port): Integer)
      .credentials(SecretArn.unwrap(credentials): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.kendra.model.BasicAuthenticationConfiguration.ReadOnly =
    zio.aws.kendra.model.BasicAuthenticationConfiguration.wrap(buildAwsValue())
}
object BasicAuthenticationConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kendra.model.BasicAuthenticationConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kendra.model.BasicAuthenticationConfiguration =
      zio.aws.kendra.model
        .BasicAuthenticationConfiguration(host, port, credentials)
    def host: Host
    def port: Port
    def credentials: SecretArn
    def getHost: ZIO[Any, Nothing, Host] = ZIO.succeed(host)
    def getPort: ZIO[Any, Nothing, Port] = ZIO.succeed(port)
    def getCredentials: ZIO[Any, Nothing, SecretArn] = ZIO.succeed(credentials)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kendra.model.BasicAuthenticationConfiguration
  ) extends zio.aws.kendra.model.BasicAuthenticationConfiguration.ReadOnly {
    override val host: Host = zio.aws.kendra.model.primitives.Host(impl.host())
    override val port: Port = zio.aws.kendra.model.primitives.Port(impl.port())
    override val credentials: SecretArn =
      zio.aws.kendra.model.primitives.SecretArn(impl.credentials())
  }
  def wrap(
      impl: software.amazon.awssdk.services.kendra.model.BasicAuthenticationConfiguration
  ): zio.aws.kendra.model.BasicAuthenticationConfiguration.ReadOnly =
    new Wrapper(impl)
}
