package zio.aws.kendra.model
import zio.ZIO
import zio.aws.kendra.model.primitives.{ErrorMessage, DocumentId}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class BatchGetDocumentStatusResponseError(
    documentId: Optional[DocumentId] = Optional.Absent,
    errorCode: Optional[zio.aws.kendra.model.ErrorCode] = Optional.Absent,
    errorMessage: Optional[ErrorMessage] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kendra.model.BatchGetDocumentStatusResponseError = {
    import BatchGetDocumentStatusResponseError.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kendra.model.BatchGetDocumentStatusResponseError
      .builder()
      .optionallyWith(
        documentId.map(value => DocumentId.unwrap(value): java.lang.String)
      )(_.documentId)
      .optionallyWith(errorCode.map(value => value.unwrap))(_.errorCode)
      .optionallyWith(
        errorMessage.map(value => ErrorMessage.unwrap(value): java.lang.String)
      )(_.errorMessage)
      .build()
  }
  def asReadOnly
      : zio.aws.kendra.model.BatchGetDocumentStatusResponseError.ReadOnly =
    zio.aws.kendra.model.BatchGetDocumentStatusResponseError
      .wrap(buildAwsValue())
}
object BatchGetDocumentStatusResponseError {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kendra.model.BatchGetDocumentStatusResponseError
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kendra.model.BatchGetDocumentStatusResponseError =
      zio.aws.kendra.model.BatchGetDocumentStatusResponseError(
        documentId.map(value => value),
        errorCode.map(value => value),
        errorMessage.map(value => value)
      )
    def documentId: Optional[DocumentId]
    def errorCode: Optional[zio.aws.kendra.model.ErrorCode]
    def errorMessage: Optional[ErrorMessage]
    def getDocumentId: ZIO[Any, AwsError, DocumentId] =
      AwsError.unwrapOptionField("documentId", documentId)
    def getErrorCode: ZIO[Any, AwsError, zio.aws.kendra.model.ErrorCode] =
      AwsError.unwrapOptionField("errorCode", errorCode)
    def getErrorMessage: ZIO[Any, AwsError, ErrorMessage] =
      AwsError.unwrapOptionField("errorMessage", errorMessage)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kendra.model.BatchGetDocumentStatusResponseError
  ) extends zio.aws.kendra.model.BatchGetDocumentStatusResponseError.ReadOnly {
    override val documentId: Optional[DocumentId] = zio.aws.core.internal
      .optionalFromNullable(impl.documentId())
      .map(value => zio.aws.kendra.model.primitives.DocumentId(value))
    override val errorCode: Optional[zio.aws.kendra.model.ErrorCode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.errorCode())
        .map(value => zio.aws.kendra.model.ErrorCode.wrap(value))
    override val errorMessage: Optional[ErrorMessage] = zio.aws.core.internal
      .optionalFromNullable(impl.errorMessage())
      .map(value => zio.aws.kendra.model.primitives.ErrorMessage(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kendra.model.BatchGetDocumentStatusResponseError
  ): zio.aws.kendra.model.BatchGetDocumentStatusResponseError.ReadOnly =
    new Wrapper(impl)
}
