package zio.aws.kendra.model
import zio.ZIO
import zio.aws.kendra.model.primitives.{ErrorMessage, DocumentId}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class BatchPutDocumentResponseFailedDocument(
    id: Optional[DocumentId] = Optional.Absent,
    errorCode: Optional[zio.aws.kendra.model.ErrorCode] = Optional.Absent,
    errorMessage: Optional[ErrorMessage] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kendra.model.BatchPutDocumentResponseFailedDocument = {
    import BatchPutDocumentResponseFailedDocument.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kendra.model.BatchPutDocumentResponseFailedDocument
      .builder()
      .optionallyWith(
        id.map(value => DocumentId.unwrap(value): java.lang.String)
      )(_.id)
      .optionallyWith(errorCode.map(value => value.unwrap))(_.errorCode)
      .optionallyWith(
        errorMessage.map(value => ErrorMessage.unwrap(value): java.lang.String)
      )(_.errorMessage)
      .build()
  }
  def asReadOnly
      : zio.aws.kendra.model.BatchPutDocumentResponseFailedDocument.ReadOnly =
    zio.aws.kendra.model.BatchPutDocumentResponseFailedDocument
      .wrap(buildAwsValue())
}
object BatchPutDocumentResponseFailedDocument {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kendra.model.BatchPutDocumentResponseFailedDocument
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.kendra.model.BatchPutDocumentResponseFailedDocument =
      zio.aws.kendra.model.BatchPutDocumentResponseFailedDocument(
        id.map(value => value),
        errorCode.map(value => value),
        errorMessage.map(value => value)
      )
    def id: Optional[DocumentId]
    def errorCode: Optional[zio.aws.kendra.model.ErrorCode]
    def errorMessage: Optional[ErrorMessage]
    def getId: ZIO[Any, AwsError, DocumentId] =
      AwsError.unwrapOptionField("id", id)
    def getErrorCode: ZIO[Any, AwsError, zio.aws.kendra.model.ErrorCode] =
      AwsError.unwrapOptionField("errorCode", errorCode)
    def getErrorMessage: ZIO[Any, AwsError, ErrorMessage] =
      AwsError.unwrapOptionField("errorMessage", errorMessage)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kendra.model.BatchPutDocumentResponseFailedDocument
  ) extends zio.aws.kendra.model.BatchPutDocumentResponseFailedDocument.ReadOnly {
    override val id: Optional[DocumentId] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value => zio.aws.kendra.model.primitives.DocumentId(value))
    override val errorCode: Optional[zio.aws.kendra.model.ErrorCode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.errorCode())
        .map(value => zio.aws.kendra.model.ErrorCode.wrap(value))
    override val errorMessage: Optional[ErrorMessage] = zio.aws.core.internal
      .optionalFromNullable(impl.errorMessage())
      .map(value => zio.aws.kendra.model.primitives.ErrorMessage(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kendra.model.BatchPutDocumentResponseFailedDocument
  ): zio.aws.kendra.model.BatchPutDocumentResponseFailedDocument.ReadOnly =
    new Wrapper(impl)
}
