package zio.aws.kendra.model
import zio.ZIO
import zio.aws.kendra.model.primitives.{
  DataSourceInclusionsExclusionsStringsMember,
  SecretArn,
  EnterpriseId
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class BoxConfiguration(
    enterpriseId: EnterpriseId,
    secretArn: SecretArn,
    useChangeLog: Optional[Boolean] = Optional.Absent,
    crawlComments: Optional[Boolean] = Optional.Absent,
    crawlTasks: Optional[Boolean] = Optional.Absent,
    crawlWebLinks: Optional[Boolean] = Optional.Absent,
    fileFieldMappings: Optional[
      Iterable[zio.aws.kendra.model.DataSourceToIndexFieldMapping]
    ] = Optional.Absent,
    taskFieldMappings: Optional[
      Iterable[zio.aws.kendra.model.DataSourceToIndexFieldMapping]
    ] = Optional.Absent,
    commentFieldMappings: Optional[
      Iterable[zio.aws.kendra.model.DataSourceToIndexFieldMapping]
    ] = Optional.Absent,
    webLinkFieldMappings: Optional[
      Iterable[zio.aws.kendra.model.DataSourceToIndexFieldMapping]
    ] = Optional.Absent,
    inclusionPatterns: Optional[
      Iterable[DataSourceInclusionsExclusionsStringsMember]
    ] = Optional.Absent,
    exclusionPatterns: Optional[
      Iterable[DataSourceInclusionsExclusionsStringsMember]
    ] = Optional.Absent,
    vpcConfiguration: Optional[
      zio.aws.kendra.model.DataSourceVpcConfiguration
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kendra.model.BoxConfiguration = {
    import BoxConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kendra.model.BoxConfiguration
      .builder()
      .enterpriseId(EnterpriseId.unwrap(enterpriseId): java.lang.String)
      .secretArn(SecretArn.unwrap(secretArn): java.lang.String)
      .optionallyWith(useChangeLog.map(value => value: java.lang.Boolean))(
        _.useChangeLog
      )
      .optionallyWith(crawlComments.map(value => value: java.lang.Boolean))(
        _.crawlComments
      )
      .optionallyWith(crawlTasks.map(value => value: java.lang.Boolean))(
        _.crawlTasks
      )
      .optionallyWith(crawlWebLinks.map(value => value: java.lang.Boolean))(
        _.crawlWebLinks
      )
      .optionallyWith(
        fileFieldMappings.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.fileFieldMappings)
      .optionallyWith(
        taskFieldMappings.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.taskFieldMappings)
      .optionallyWith(
        commentFieldMappings.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.commentFieldMappings)
      .optionallyWith(
        webLinkFieldMappings.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.webLinkFieldMappings)
      .optionallyWith(
        inclusionPatterns.map(value =>
          value.map { item =>
            DataSourceInclusionsExclusionsStringsMember.unwrap(
              item
            ): java.lang.String
          }.asJavaCollection
        )
      )(_.inclusionPatterns)
      .optionallyWith(
        exclusionPatterns.map(value =>
          value.map { item =>
            DataSourceInclusionsExclusionsStringsMember.unwrap(
              item
            ): java.lang.String
          }.asJavaCollection
        )
      )(_.exclusionPatterns)
      .optionallyWith(vpcConfiguration.map(value => value.buildAwsValue()))(
        _.vpcConfiguration
      )
      .build()
  }
  def asReadOnly: zio.aws.kendra.model.BoxConfiguration.ReadOnly =
    zio.aws.kendra.model.BoxConfiguration.wrap(buildAwsValue())
}
object BoxConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kendra.model.BoxConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kendra.model.BoxConfiguration =
      zio.aws.kendra.model.BoxConfiguration(
        enterpriseId,
        secretArn,
        useChangeLog.map(value => value),
        crawlComments.map(value => value),
        crawlTasks.map(value => value),
        crawlWebLinks.map(value => value),
        fileFieldMappings.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        taskFieldMappings.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        commentFieldMappings.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        webLinkFieldMappings.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        inclusionPatterns.map(value => value),
        exclusionPatterns.map(value => value),
        vpcConfiguration.map(value => value.asEditable)
      )
    def enterpriseId: EnterpriseId
    def secretArn: SecretArn
    def useChangeLog: Optional[Boolean]
    def crawlComments: Optional[Boolean]
    def crawlTasks: Optional[Boolean]
    def crawlWebLinks: Optional[Boolean]
    def fileFieldMappings: Optional[
      List[zio.aws.kendra.model.DataSourceToIndexFieldMapping.ReadOnly]
    ]
    def taskFieldMappings: Optional[
      List[zio.aws.kendra.model.DataSourceToIndexFieldMapping.ReadOnly]
    ]
    def commentFieldMappings: Optional[
      List[zio.aws.kendra.model.DataSourceToIndexFieldMapping.ReadOnly]
    ]
    def webLinkFieldMappings: Optional[
      List[zio.aws.kendra.model.DataSourceToIndexFieldMapping.ReadOnly]
    ]
    def inclusionPatterns
        : Optional[List[DataSourceInclusionsExclusionsStringsMember]]
    def exclusionPatterns
        : Optional[List[DataSourceInclusionsExclusionsStringsMember]]
    def vpcConfiguration
        : Optional[zio.aws.kendra.model.DataSourceVpcConfiguration.ReadOnly]
    def getEnterpriseId: ZIO[Any, Nothing, EnterpriseId] =
      ZIO.succeed(enterpriseId)
    def getSecretArn: ZIO[Any, Nothing, SecretArn] = ZIO.succeed(secretArn)
    def getUseChangeLog: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("useChangeLog", useChangeLog)
    def getCrawlComments: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("crawlComments", crawlComments)
    def getCrawlTasks: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("crawlTasks", crawlTasks)
    def getCrawlWebLinks: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("crawlWebLinks", crawlWebLinks)
    def getFileFieldMappings: ZIO[Any, AwsError, List[
      zio.aws.kendra.model.DataSourceToIndexFieldMapping.ReadOnly
    ]] = AwsError.unwrapOptionField("fileFieldMappings", fileFieldMappings)
    def getTaskFieldMappings: ZIO[Any, AwsError, List[
      zio.aws.kendra.model.DataSourceToIndexFieldMapping.ReadOnly
    ]] = AwsError.unwrapOptionField("taskFieldMappings", taskFieldMappings)
    def getCommentFieldMappings: ZIO[Any, AwsError, List[
      zio.aws.kendra.model.DataSourceToIndexFieldMapping.ReadOnly
    ]] =
      AwsError.unwrapOptionField("commentFieldMappings", commentFieldMappings)
    def getWebLinkFieldMappings: ZIO[Any, AwsError, List[
      zio.aws.kendra.model.DataSourceToIndexFieldMapping.ReadOnly
    ]] =
      AwsError.unwrapOptionField("webLinkFieldMappings", webLinkFieldMappings)
    def getInclusionPatterns: ZIO[Any, AwsError, List[
      DataSourceInclusionsExclusionsStringsMember
    ]] = AwsError.unwrapOptionField("inclusionPatterns", inclusionPatterns)
    def getExclusionPatterns: ZIO[Any, AwsError, List[
      DataSourceInclusionsExclusionsStringsMember
    ]] = AwsError.unwrapOptionField("exclusionPatterns", exclusionPatterns)
    def getVpcConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.kendra.model.DataSourceVpcConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("vpcConfiguration", vpcConfiguration)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kendra.model.BoxConfiguration
  ) extends zio.aws.kendra.model.BoxConfiguration.ReadOnly {
    override val enterpriseId: EnterpriseId =
      zio.aws.kendra.model.primitives.EnterpriseId(impl.enterpriseId())
    override val secretArn: SecretArn =
      zio.aws.kendra.model.primitives.SecretArn(impl.secretArn())
    override val useChangeLog: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.useChangeLog())
      .map(value => value: Boolean)
    override val crawlComments: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.crawlComments())
      .map(value => value: Boolean)
    override val crawlTasks: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.crawlTasks())
      .map(value => value: Boolean)
    override val crawlWebLinks: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.crawlWebLinks())
      .map(value => value: Boolean)
    override val fileFieldMappings: Optional[
      List[zio.aws.kendra.model.DataSourceToIndexFieldMapping.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.fileFieldMappings())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.kendra.model.DataSourceToIndexFieldMapping.wrap(item)
        }.toList
      )
    override val taskFieldMappings: Optional[
      List[zio.aws.kendra.model.DataSourceToIndexFieldMapping.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.taskFieldMappings())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.kendra.model.DataSourceToIndexFieldMapping.wrap(item)
        }.toList
      )
    override val commentFieldMappings: Optional[
      List[zio.aws.kendra.model.DataSourceToIndexFieldMapping.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.commentFieldMappings())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.kendra.model.DataSourceToIndexFieldMapping.wrap(item)
        }.toList
      )
    override val webLinkFieldMappings: Optional[
      List[zio.aws.kendra.model.DataSourceToIndexFieldMapping.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.webLinkFieldMappings())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.kendra.model.DataSourceToIndexFieldMapping.wrap(item)
        }.toList
      )
    override val inclusionPatterns
        : Optional[List[DataSourceInclusionsExclusionsStringsMember]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.inclusionPatterns())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.kendra.model.primitives
              .DataSourceInclusionsExclusionsStringsMember(item)
          }.toList
        )
    override val exclusionPatterns
        : Optional[List[DataSourceInclusionsExclusionsStringsMember]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.exclusionPatterns())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.kendra.model.primitives
              .DataSourceInclusionsExclusionsStringsMember(item)
          }.toList
        )
    override val vpcConfiguration
        : Optional[zio.aws.kendra.model.DataSourceVpcConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.vpcConfiguration())
        .map(value =>
          zio.aws.kendra.model.DataSourceVpcConfiguration.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.kendra.model.BoxConfiguration
  ): zio.aws.kendra.model.BoxConfiguration.ReadOnly = new Wrapper(impl)
}
