package zio.aws.kendra.model
import zio.ZIO
import zio.aws.kendra.model.primitives.IndexId
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class ClearQuerySuggestionsRequest(indexId: IndexId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kendra.model.ClearQuerySuggestionsRequest = {
    import ClearQuerySuggestionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kendra.model.ClearQuerySuggestionsRequest
      .builder()
      .indexId(IndexId.unwrap(indexId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.kendra.model.ClearQuerySuggestionsRequest.ReadOnly =
    zio.aws.kendra.model.ClearQuerySuggestionsRequest.wrap(buildAwsValue())
}
object ClearQuerySuggestionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kendra.model.ClearQuerySuggestionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kendra.model.ClearQuerySuggestionsRequest =
      zio.aws.kendra.model.ClearQuerySuggestionsRequest(indexId)
    def indexId: IndexId
    def getIndexId: ZIO[Any, Nothing, IndexId] = ZIO.succeed(indexId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kendra.model.ClearQuerySuggestionsRequest
  ) extends zio.aws.kendra.model.ClearQuerySuggestionsRequest.ReadOnly {
    override val indexId: IndexId =
      zio.aws.kendra.model.primitives.IndexId(impl.indexId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.kendra.model.ClearQuerySuggestionsRequest
  ): zio.aws.kendra.model.ClearQuerySuggestionsRequest.ReadOnly = new Wrapper(
    impl
  )
}
