package zio.aws.kendra.model
import scala.jdk.CollectionConverters._
sealed trait ConditionOperator {
  def unwrap: software.amazon.awssdk.services.kendra.model.ConditionOperator
}
object ConditionOperator {
  def wrap(
      value: software.amazon.awssdk.services.kendra.model.ConditionOperator
  ): zio.aws.kendra.model.ConditionOperator = value match {
    case software.amazon.awssdk.services.kendra.model.ConditionOperator.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.kendra.model.ConditionOperator.GREATER_THAN =>
      val r = GreaterThan
      r
    case software.amazon.awssdk.services.kendra.model.ConditionOperator.GREATER_THAN_OR_EQUALS =>
      val r = GreaterThanOrEquals
      r
    case software.amazon.awssdk.services.kendra.model.ConditionOperator.LESS_THAN =>
      val r = LessThan
      r
    case software.amazon.awssdk.services.kendra.model.ConditionOperator.LESS_THAN_OR_EQUALS =>
      val r = LessThanOrEquals
      r
    case software.amazon.awssdk.services.kendra.model.ConditionOperator.EQUALS =>
      val r = Equals
      r
    case software.amazon.awssdk.services.kendra.model.ConditionOperator.NOT_EQUALS =>
      val r = NotEquals
      r
    case software.amazon.awssdk.services.kendra.model.ConditionOperator.CONTAINS =>
      val r = Contains
      r
    case software.amazon.awssdk.services.kendra.model.ConditionOperator.NOT_CONTAINS =>
      val r = NotContains
      r
    case software.amazon.awssdk.services.kendra.model.ConditionOperator.EXISTS =>
      val r = Exists
      r
    case software.amazon.awssdk.services.kendra.model.ConditionOperator.NOT_EXISTS =>
      val r = NotExists
      r
    case software.amazon.awssdk.services.kendra.model.ConditionOperator.BEGINS_WITH =>
      val r = BeginsWith
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.kendra.model.ConditionOperator {
    override def unwrap
        : software.amazon.awssdk.services.kendra.model.ConditionOperator =
      software.amazon.awssdk.services.kendra.model.ConditionOperator.UNKNOWN_TO_SDK_VERSION
  }
  case object GreaterThan extends zio.aws.kendra.model.ConditionOperator {
    override def unwrap
        : software.amazon.awssdk.services.kendra.model.ConditionOperator =
      software.amazon.awssdk.services.kendra.model.ConditionOperator.GREATER_THAN
  }
  case object GreaterThanOrEquals
      extends zio.aws.kendra.model.ConditionOperator {
    override def unwrap
        : software.amazon.awssdk.services.kendra.model.ConditionOperator =
      software.amazon.awssdk.services.kendra.model.ConditionOperator.GREATER_THAN_OR_EQUALS
  }
  case object LessThan extends zio.aws.kendra.model.ConditionOperator {
    override def unwrap
        : software.amazon.awssdk.services.kendra.model.ConditionOperator =
      software.amazon.awssdk.services.kendra.model.ConditionOperator.LESS_THAN
  }
  case object LessThanOrEquals extends zio.aws.kendra.model.ConditionOperator {
    override def unwrap
        : software.amazon.awssdk.services.kendra.model.ConditionOperator =
      software.amazon.awssdk.services.kendra.model.ConditionOperator.LESS_THAN_OR_EQUALS
  }
  case object Equals extends zio.aws.kendra.model.ConditionOperator {
    override def unwrap
        : software.amazon.awssdk.services.kendra.model.ConditionOperator =
      software.amazon.awssdk.services.kendra.model.ConditionOperator.EQUALS
  }
  case object NotEquals extends zio.aws.kendra.model.ConditionOperator {
    override def unwrap
        : software.amazon.awssdk.services.kendra.model.ConditionOperator =
      software.amazon.awssdk.services.kendra.model.ConditionOperator.NOT_EQUALS
  }
  case object Contains extends zio.aws.kendra.model.ConditionOperator {
    override def unwrap
        : software.amazon.awssdk.services.kendra.model.ConditionOperator =
      software.amazon.awssdk.services.kendra.model.ConditionOperator.CONTAINS
  }
  case object NotContains extends zio.aws.kendra.model.ConditionOperator {
    override def unwrap
        : software.amazon.awssdk.services.kendra.model.ConditionOperator =
      software.amazon.awssdk.services.kendra.model.ConditionOperator.NOT_CONTAINS
  }
  case object Exists extends zio.aws.kendra.model.ConditionOperator {
    override def unwrap
        : software.amazon.awssdk.services.kendra.model.ConditionOperator =
      software.amazon.awssdk.services.kendra.model.ConditionOperator.EXISTS
  }
  case object NotExists extends zio.aws.kendra.model.ConditionOperator {
    override def unwrap
        : software.amazon.awssdk.services.kendra.model.ConditionOperator =
      software.amazon.awssdk.services.kendra.model.ConditionOperator.NOT_EXISTS
  }
  case object BeginsWith extends zio.aws.kendra.model.ConditionOperator {
    override def unwrap
        : software.amazon.awssdk.services.kendra.model.ConditionOperator =
      software.amazon.awssdk.services.kendra.model.ConditionOperator.BEGINS_WITH
  }
}
