package zio.aws.kendra.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ConfluenceAttachmentConfiguration(
    crawlAttachments: Optional[Boolean] = Optional.Absent,
    attachmentFieldMappings: Optional[
      Iterable[zio.aws.kendra.model.ConfluenceAttachmentToIndexFieldMapping]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kendra.model.ConfluenceAttachmentConfiguration = {
    import ConfluenceAttachmentConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kendra.model.ConfluenceAttachmentConfiguration
      .builder()
      .optionallyWith(crawlAttachments.map(value => value: java.lang.Boolean))(
        _.crawlAttachments
      )
      .optionallyWith(
        attachmentFieldMappings.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.attachmentFieldMappings)
      .build()
  }
  def asReadOnly
      : zio.aws.kendra.model.ConfluenceAttachmentConfiguration.ReadOnly =
    zio.aws.kendra.model.ConfluenceAttachmentConfiguration.wrap(buildAwsValue())
}
object ConfluenceAttachmentConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kendra.model.ConfluenceAttachmentConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kendra.model.ConfluenceAttachmentConfiguration =
      zio.aws.kendra.model.ConfluenceAttachmentConfiguration(
        crawlAttachments.map(value => value),
        attachmentFieldMappings.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def crawlAttachments: Optional[Boolean]
    def attachmentFieldMappings: Optional[List[
      zio.aws.kendra.model.ConfluenceAttachmentToIndexFieldMapping.ReadOnly
    ]]
    def getCrawlAttachments: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("crawlAttachments", crawlAttachments)
    def getAttachmentFieldMappings: ZIO[Any, AwsError, List[
      zio.aws.kendra.model.ConfluenceAttachmentToIndexFieldMapping.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "attachmentFieldMappings",
      attachmentFieldMappings
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kendra.model.ConfluenceAttachmentConfiguration
  ) extends zio.aws.kendra.model.ConfluenceAttachmentConfiguration.ReadOnly {
    override val crawlAttachments: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.crawlAttachments())
      .map(value => value: Boolean)
    override val attachmentFieldMappings: Optional[List[
      zio.aws.kendra.model.ConfluenceAttachmentToIndexFieldMapping.ReadOnly
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.attachmentFieldMappings())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.kendra.model.ConfluenceAttachmentToIndexFieldMapping
            .wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.kendra.model.ConfluenceAttachmentConfiguration
  ): zio.aws.kendra.model.ConfluenceAttachmentConfiguration.ReadOnly =
    new Wrapper(impl)
}
