package zio.aws.kendra.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ConfluenceBlogConfiguration(
    blogFieldMappings: Optional[
      Iterable[zio.aws.kendra.model.ConfluenceBlogToIndexFieldMapping]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kendra.model.ConfluenceBlogConfiguration = {
    import ConfluenceBlogConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kendra.model.ConfluenceBlogConfiguration
      .builder()
      .optionallyWith(
        blogFieldMappings.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.blogFieldMappings)
      .build()
  }
  def asReadOnly: zio.aws.kendra.model.ConfluenceBlogConfiguration.ReadOnly =
    zio.aws.kendra.model.ConfluenceBlogConfiguration.wrap(buildAwsValue())
}
object ConfluenceBlogConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kendra.model.ConfluenceBlogConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kendra.model.ConfluenceBlogConfiguration =
      zio.aws.kendra.model.ConfluenceBlogConfiguration(
        blogFieldMappings.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def blogFieldMappings: Optional[
      List[zio.aws.kendra.model.ConfluenceBlogToIndexFieldMapping.ReadOnly]
    ]
    def getBlogFieldMappings: ZIO[Any, AwsError, List[
      zio.aws.kendra.model.ConfluenceBlogToIndexFieldMapping.ReadOnly
    ]] = AwsError.unwrapOptionField("blogFieldMappings", blogFieldMappings)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kendra.model.ConfluenceBlogConfiguration
  ) extends zio.aws.kendra.model.ConfluenceBlogConfiguration.ReadOnly {
    override val blogFieldMappings: Optional[
      List[zio.aws.kendra.model.ConfluenceBlogToIndexFieldMapping.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.blogFieldMappings())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.kendra.model.ConfluenceBlogToIndexFieldMapping.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.kendra.model.ConfluenceBlogConfiguration
  ): zio.aws.kendra.model.ConfluenceBlogConfiguration.ReadOnly = new Wrapper(
    impl
  )
}
