package zio.aws.kendra.model
import zio.ZIO
import zio.aws.kendra.model.primitives.{
  IndexFieldName,
  DataSourceDateFieldFormat
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ConfluenceBlogToIndexFieldMapping(
    dataSourceFieldName: Optional[
      zio.aws.kendra.model.ConfluenceBlogFieldName
    ] = Optional.Absent,
    dateFieldFormat: Optional[DataSourceDateFieldFormat] = Optional.Absent,
    indexFieldName: Optional[IndexFieldName] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kendra.model.ConfluenceBlogToIndexFieldMapping = {
    import ConfluenceBlogToIndexFieldMapping.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kendra.model.ConfluenceBlogToIndexFieldMapping
      .builder()
      .optionallyWith(dataSourceFieldName.map(value => value.unwrap))(
        _.dataSourceFieldName
      )
      .optionallyWith(
        dateFieldFormat.map(value =>
          DataSourceDateFieldFormat.unwrap(value): java.lang.String
        )
      )(_.dateFieldFormat)
      .optionallyWith(
        indexFieldName.map(value =>
          IndexFieldName.unwrap(value): java.lang.String
        )
      )(_.indexFieldName)
      .build()
  }
  def asReadOnly
      : zio.aws.kendra.model.ConfluenceBlogToIndexFieldMapping.ReadOnly =
    zio.aws.kendra.model.ConfluenceBlogToIndexFieldMapping.wrap(buildAwsValue())
}
object ConfluenceBlogToIndexFieldMapping {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kendra.model.ConfluenceBlogToIndexFieldMapping
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kendra.model.ConfluenceBlogToIndexFieldMapping =
      zio.aws.kendra.model.ConfluenceBlogToIndexFieldMapping(
        dataSourceFieldName.map(value => value),
        dateFieldFormat.map(value => value),
        indexFieldName.map(value => value)
      )
    def dataSourceFieldName
        : Optional[zio.aws.kendra.model.ConfluenceBlogFieldName]
    def dateFieldFormat: Optional[DataSourceDateFieldFormat]
    def indexFieldName: Optional[IndexFieldName]
    def getDataSourceFieldName
        : ZIO[Any, AwsError, zio.aws.kendra.model.ConfluenceBlogFieldName] =
      AwsError.unwrapOptionField("dataSourceFieldName", dataSourceFieldName)
    def getDateFieldFormat: ZIO[Any, AwsError, DataSourceDateFieldFormat] =
      AwsError.unwrapOptionField("dateFieldFormat", dateFieldFormat)
    def getIndexFieldName: ZIO[Any, AwsError, IndexFieldName] =
      AwsError.unwrapOptionField("indexFieldName", indexFieldName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kendra.model.ConfluenceBlogToIndexFieldMapping
  ) extends zio.aws.kendra.model.ConfluenceBlogToIndexFieldMapping.ReadOnly {
    override val dataSourceFieldName
        : Optional[zio.aws.kendra.model.ConfluenceBlogFieldName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dataSourceFieldName())
        .map(value => zio.aws.kendra.model.ConfluenceBlogFieldName.wrap(value))
    override val dateFieldFormat: Optional[DataSourceDateFieldFormat] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dateFieldFormat())
        .map(value =>
          zio.aws.kendra.model.primitives.DataSourceDateFieldFormat(value)
        )
    override val indexFieldName: Optional[IndexFieldName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.indexFieldName())
        .map(value => zio.aws.kendra.model.primitives.IndexFieldName(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kendra.model.ConfluenceBlogToIndexFieldMapping
  ): zio.aws.kendra.model.ConfluenceBlogToIndexFieldMapping.ReadOnly =
    new Wrapper(impl)
}
