package zio.aws.kendra.model
import java.lang.Integer
import zio.ZIO
import zio.aws.kendra.model.primitives.{
  TableName,
  SecretArn,
  DatabaseHost,
  DatabaseName,
  DatabasePort
}
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class ConnectionConfiguration(
    databaseHost: DatabaseHost,
    databasePort: DatabasePort,
    databaseName: DatabaseName,
    tableName: TableName,
    secretArn: SecretArn
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kendra.model.ConnectionConfiguration = {
    import ConnectionConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kendra.model.ConnectionConfiguration
      .builder()
      .databaseHost(DatabaseHost.unwrap(databaseHost): java.lang.String)
      .databasePort(DatabasePort.unwrap(databasePort): Integer)
      .databaseName(DatabaseName.unwrap(databaseName): java.lang.String)
      .tableName(TableName.unwrap(tableName): java.lang.String)
      .secretArn(SecretArn.unwrap(secretArn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.kendra.model.ConnectionConfiguration.ReadOnly =
    zio.aws.kendra.model.ConnectionConfiguration.wrap(buildAwsValue())
}
object ConnectionConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kendra.model.ConnectionConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kendra.model.ConnectionConfiguration =
      zio.aws.kendra.model.ConnectionConfiguration(
        databaseHost,
        databasePort,
        databaseName,
        tableName,
        secretArn
      )
    def databaseHost: DatabaseHost
    def databasePort: DatabasePort
    def databaseName: DatabaseName
    def tableName: TableName
    def secretArn: SecretArn
    def getDatabaseHost: ZIO[Any, Nothing, DatabaseHost] =
      ZIO.succeed(databaseHost)
    def getDatabasePort: ZIO[Any, Nothing, DatabasePort] =
      ZIO.succeed(databasePort)
    def getDatabaseName: ZIO[Any, Nothing, DatabaseName] =
      ZIO.succeed(databaseName)
    def getTableName: ZIO[Any, Nothing, TableName] = ZIO.succeed(tableName)
    def getSecretArn: ZIO[Any, Nothing, SecretArn] = ZIO.succeed(secretArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kendra.model.ConnectionConfiguration
  ) extends zio.aws.kendra.model.ConnectionConfiguration.ReadOnly {
    override val databaseHost: DatabaseHost =
      zio.aws.kendra.model.primitives.DatabaseHost(impl.databaseHost())
    override val databasePort: DatabasePort =
      zio.aws.kendra.model.primitives.DatabasePort(impl.databasePort())
    override val databaseName: DatabaseName =
      zio.aws.kendra.model.primitives.DatabaseName(impl.databaseName())
    override val tableName: TableName =
      zio.aws.kendra.model.primitives.TableName(impl.tableName())
    override val secretArn: SecretArn =
      zio.aws.kendra.model.primitives.SecretArn(impl.secretArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.kendra.model.ConnectionConfiguration
  ): zio.aws.kendra.model.ConnectionConfiguration.ReadOnly = new Wrapper(impl)
}
