package zio.aws.kendra.model
import zio.ZIO
import zio.aws.kendra.model.primitives.{
  ClientTokenName,
  Description,
  RoleArn,
  IndexName
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateIndexRequest(
    name: IndexName,
    edition: Optional[zio.aws.kendra.model.IndexEdition] = Optional.Absent,
    roleArn: RoleArn,
    serverSideEncryptionConfiguration: Optional[
      zio.aws.kendra.model.ServerSideEncryptionConfiguration
    ] = Optional.Absent,
    description: Optional[Description] = Optional.Absent,
    clientToken: Optional[ClientTokenName] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.kendra.model.Tag]] = Optional.Absent,
    userTokenConfigurations: Optional[
      Iterable[zio.aws.kendra.model.UserTokenConfiguration]
    ] = Optional.Absent,
    userContextPolicy: Optional[zio.aws.kendra.model.UserContextPolicy] =
      Optional.Absent,
    userGroupResolutionConfiguration: Optional[
      zio.aws.kendra.model.UserGroupResolutionConfiguration
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kendra.model.CreateIndexRequest = {
    import CreateIndexRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kendra.model.CreateIndexRequest
      .builder()
      .name(IndexName.unwrap(name): java.lang.String)
      .optionallyWith(edition.map(value => value.unwrap))(_.edition)
      .roleArn(RoleArn.unwrap(roleArn): java.lang.String)
      .optionallyWith(
        serverSideEncryptionConfiguration.map(value => value.buildAwsValue())
      )(_.serverSideEncryptionConfiguration)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        clientToken.map(value =>
          ClientTokenName.unwrap(value): java.lang.String
        )
      )(_.clientToken)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(
        userTokenConfigurations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.userTokenConfigurations)
      .optionallyWith(userContextPolicy.map(value => value.unwrap))(
        _.userContextPolicy
      )
      .optionallyWith(
        userGroupResolutionConfiguration.map(value => value.buildAwsValue())
      )(_.userGroupResolutionConfiguration)
      .build()
  }
  def asReadOnly: zio.aws.kendra.model.CreateIndexRequest.ReadOnly =
    zio.aws.kendra.model.CreateIndexRequest.wrap(buildAwsValue())
}
object CreateIndexRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kendra.model.CreateIndexRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kendra.model.CreateIndexRequest =
      zio.aws.kendra.model.CreateIndexRequest(
        name,
        edition.map(value => value),
        roleArn,
        serverSideEncryptionConfiguration.map(value => value.asEditable),
        description.map(value => value),
        clientToken.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        userTokenConfigurations.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        userContextPolicy.map(value => value),
        userGroupResolutionConfiguration.map(value => value.asEditable)
      )
    def name: IndexName
    def edition: Optional[zio.aws.kendra.model.IndexEdition]
    def roleArn: RoleArn
    def serverSideEncryptionConfiguration: Optional[
      zio.aws.kendra.model.ServerSideEncryptionConfiguration.ReadOnly
    ]
    def description: Optional[Description]
    def clientToken: Optional[ClientTokenName]
    def tags: Optional[List[zio.aws.kendra.model.Tag.ReadOnly]]
    def userTokenConfigurations
        : Optional[List[zio.aws.kendra.model.UserTokenConfiguration.ReadOnly]]
    def userContextPolicy: Optional[zio.aws.kendra.model.UserContextPolicy]
    def userGroupResolutionConfiguration: Optional[
      zio.aws.kendra.model.UserGroupResolutionConfiguration.ReadOnly
    ]
    def getName: ZIO[Any, Nothing, IndexName] = ZIO.succeed(name)
    def getEdition: ZIO[Any, AwsError, zio.aws.kendra.model.IndexEdition] =
      AwsError.unwrapOptionField("edition", edition)
    def getRoleArn: ZIO[Any, Nothing, RoleArn] = ZIO.succeed(roleArn)
    def getServerSideEncryptionConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.kendra.model.ServerSideEncryptionConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "serverSideEncryptionConfiguration",
      serverSideEncryptionConfiguration
    )
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getClientToken: ZIO[Any, AwsError, ClientTokenName] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getTags: ZIO[Any, AwsError, List[zio.aws.kendra.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getUserTokenConfigurations: ZIO[Any, AwsError, List[
      zio.aws.kendra.model.UserTokenConfiguration.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "userTokenConfigurations",
      userTokenConfigurations
    )
    def getUserContextPolicy
        : ZIO[Any, AwsError, zio.aws.kendra.model.UserContextPolicy] =
      AwsError.unwrapOptionField("userContextPolicy", userContextPolicy)
    def getUserGroupResolutionConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.kendra.model.UserGroupResolutionConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "userGroupResolutionConfiguration",
      userGroupResolutionConfiguration
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kendra.model.CreateIndexRequest
  ) extends zio.aws.kendra.model.CreateIndexRequest.ReadOnly {
    override val name: IndexName =
      zio.aws.kendra.model.primitives.IndexName(impl.name())
    override val edition: Optional[zio.aws.kendra.model.IndexEdition] =
      zio.aws.core.internal
        .optionalFromNullable(impl.edition())
        .map(value => zio.aws.kendra.model.IndexEdition.wrap(value))
    override val roleArn: RoleArn =
      zio.aws.kendra.model.primitives.RoleArn(impl.roleArn())
    override val serverSideEncryptionConfiguration: Optional[
      zio.aws.kendra.model.ServerSideEncryptionConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.serverSideEncryptionConfiguration())
      .map(value =>
        zio.aws.kendra.model.ServerSideEncryptionConfiguration.wrap(value)
      )
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.kendra.model.primitives.Description(value))
    override val clientToken: Optional[ClientTokenName] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => zio.aws.kendra.model.primitives.ClientTokenName(value))
    override val tags: Optional[List[zio.aws.kendra.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.kendra.model.Tag.wrap(item)
          }.toList
        )
    override val userTokenConfigurations
        : Optional[List[zio.aws.kendra.model.UserTokenConfiguration.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.userTokenConfigurations())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.kendra.model.UserTokenConfiguration.wrap(item)
          }.toList
        )
    override val userContextPolicy
        : Optional[zio.aws.kendra.model.UserContextPolicy] =
      zio.aws.core.internal
        .optionalFromNullable(impl.userContextPolicy())
        .map(value => zio.aws.kendra.model.UserContextPolicy.wrap(value))
    override val userGroupResolutionConfiguration: Optional[
      zio.aws.kendra.model.UserGroupResolutionConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.userGroupResolutionConfiguration())
      .map(value =>
        zio.aws.kendra.model.UserGroupResolutionConfiguration.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.kendra.model.CreateIndexRequest
  ): zio.aws.kendra.model.CreateIndexRequest.ReadOnly = new Wrapper(impl)
}
