package zio.aws.kendra.model
import zio.ZIO
import zio.aws.kendra.model.primitives.{DataSourceId, PrincipalName}
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DataSourceGroup(
    groupId: PrincipalName,
    dataSourceId: DataSourceId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kendra.model.DataSourceGroup = {
    import DataSourceGroup.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kendra.model.DataSourceGroup
      .builder()
      .groupId(PrincipalName.unwrap(groupId): java.lang.String)
      .dataSourceId(DataSourceId.unwrap(dataSourceId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.kendra.model.DataSourceGroup.ReadOnly =
    zio.aws.kendra.model.DataSourceGroup.wrap(buildAwsValue())
}
object DataSourceGroup {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kendra.model.DataSourceGroup
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kendra.model.DataSourceGroup =
      zio.aws.kendra.model.DataSourceGroup(groupId, dataSourceId)
    def groupId: PrincipalName
    def dataSourceId: DataSourceId
    def getGroupId: ZIO[Any, Nothing, PrincipalName] = ZIO.succeed(groupId)
    def getDataSourceId: ZIO[Any, Nothing, DataSourceId] =
      ZIO.succeed(dataSourceId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kendra.model.DataSourceGroup
  ) extends zio.aws.kendra.model.DataSourceGroup.ReadOnly {
    override val groupId: PrincipalName =
      zio.aws.kendra.model.primitives.PrincipalName(impl.groupId())
    override val dataSourceId: DataSourceId =
      zio.aws.kendra.model.primitives.DataSourceId(impl.dataSourceId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.kendra.model.DataSourceGroup
  ): zio.aws.kendra.model.DataSourceGroup.ReadOnly = new Wrapper(impl)
}
