package zio.aws.kendra.model
import scala.jdk.CollectionConverters._
sealed trait DataSourceStatus {
  def unwrap: software.amazon.awssdk.services.kendra.model.DataSourceStatus
}
object DataSourceStatus {
  def wrap(
      value: software.amazon.awssdk.services.kendra.model.DataSourceStatus
  ): zio.aws.kendra.model.DataSourceStatus = value match {
    case software.amazon.awssdk.services.kendra.model.DataSourceStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.kendra.model.DataSourceStatus.CREATING =>
      val r = CREATING
      r
    case software.amazon.awssdk.services.kendra.model.DataSourceStatus.DELETING =>
      val r = DELETING
      r
    case software.amazon.awssdk.services.kendra.model.DataSourceStatus.FAILED =>
      val r = FAILED
      r
    case software.amazon.awssdk.services.kendra.model.DataSourceStatus.UPDATING =>
      val r = UPDATING
      r
    case software.amazon.awssdk.services.kendra.model.DataSourceStatus.ACTIVE =>
      val r = ACTIVE
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.kendra.model.DataSourceStatus {
    override def unwrap
        : software.amazon.awssdk.services.kendra.model.DataSourceStatus =
      software.amazon.awssdk.services.kendra.model.DataSourceStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object CREATING extends zio.aws.kendra.model.DataSourceStatus {
    override def unwrap
        : software.amazon.awssdk.services.kendra.model.DataSourceStatus =
      software.amazon.awssdk.services.kendra.model.DataSourceStatus.CREATING
  }
  case object DELETING extends zio.aws.kendra.model.DataSourceStatus {
    override def unwrap
        : software.amazon.awssdk.services.kendra.model.DataSourceStatus =
      software.amazon.awssdk.services.kendra.model.DataSourceStatus.DELETING
  }
  case object FAILED extends zio.aws.kendra.model.DataSourceStatus {
    override def unwrap
        : software.amazon.awssdk.services.kendra.model.DataSourceStatus =
      software.amazon.awssdk.services.kendra.model.DataSourceStatus.FAILED
  }
  case object UPDATING extends zio.aws.kendra.model.DataSourceStatus {
    override def unwrap
        : software.amazon.awssdk.services.kendra.model.DataSourceStatus =
      software.amazon.awssdk.services.kendra.model.DataSourceStatus.UPDATING
  }
  case object ACTIVE extends zio.aws.kendra.model.DataSourceStatus {
    override def unwrap
        : software.amazon.awssdk.services.kendra.model.DataSourceStatus =
      software.amazon.awssdk.services.kendra.model.DataSourceStatus.ACTIVE
  }
}
