package zio.aws.kendra.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.kendra.model.primitives.{ErrorMessage, Timestamp}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class DataSourceSyncJob(
    executionId: Optional[String] = Optional.Absent,
    startTime: Optional[Timestamp] = Optional.Absent,
    endTime: Optional[Timestamp] = Optional.Absent,
    status: Optional[zio.aws.kendra.model.DataSourceSyncJobStatus] =
      Optional.Absent,
    errorMessage: Optional[ErrorMessage] = Optional.Absent,
    errorCode: Optional[zio.aws.kendra.model.ErrorCode] = Optional.Absent,
    dataSourceErrorCode: Optional[String] = Optional.Absent,
    metrics: Optional[zio.aws.kendra.model.DataSourceSyncJobMetrics] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kendra.model.DataSourceSyncJob = {
    import DataSourceSyncJob.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kendra.model.DataSourceSyncJob
      .builder()
      .optionallyWith(executionId.map(value => value: java.lang.String))(
        _.executionId
      )
      .optionallyWith(startTime.map(value => Timestamp.unwrap(value): Instant))(
        _.startTime
      )
      .optionallyWith(endTime.map(value => Timestamp.unwrap(value): Instant))(
        _.endTime
      )
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        errorMessage.map(value => ErrorMessage.unwrap(value): java.lang.String)
      )(_.errorMessage)
      .optionallyWith(errorCode.map(value => value.unwrap))(_.errorCode)
      .optionallyWith(
        dataSourceErrorCode.map(value => value: java.lang.String)
      )(_.dataSourceErrorCode)
      .optionallyWith(metrics.map(value => value.buildAwsValue()))(_.metrics)
      .build()
  }
  def asReadOnly: zio.aws.kendra.model.DataSourceSyncJob.ReadOnly =
    zio.aws.kendra.model.DataSourceSyncJob.wrap(buildAwsValue())
}
object DataSourceSyncJob {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kendra.model.DataSourceSyncJob
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kendra.model.DataSourceSyncJob =
      zio.aws.kendra.model.DataSourceSyncJob(
        executionId.map(value => value),
        startTime.map(value => value),
        endTime.map(value => value),
        status.map(value => value),
        errorMessage.map(value => value),
        errorCode.map(value => value),
        dataSourceErrorCode.map(value => value),
        metrics.map(value => value.asEditable)
      )
    def executionId: Optional[String]
    def startTime: Optional[Timestamp]
    def endTime: Optional[Timestamp]
    def status: Optional[zio.aws.kendra.model.DataSourceSyncJobStatus]
    def errorMessage: Optional[ErrorMessage]
    def errorCode: Optional[zio.aws.kendra.model.ErrorCode]
    def dataSourceErrorCode: Optional[String]
    def metrics
        : Optional[zio.aws.kendra.model.DataSourceSyncJobMetrics.ReadOnly]
    def getExecutionId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("executionId", executionId)
    def getStartTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("startTime", startTime)
    def getEndTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("endTime", endTime)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.kendra.model.DataSourceSyncJobStatus] =
      AwsError.unwrapOptionField("status", status)
    def getErrorMessage: ZIO[Any, AwsError, ErrorMessage] =
      AwsError.unwrapOptionField("errorMessage", errorMessage)
    def getErrorCode: ZIO[Any, AwsError, zio.aws.kendra.model.ErrorCode] =
      AwsError.unwrapOptionField("errorCode", errorCode)
    def getDataSourceErrorCode: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dataSourceErrorCode", dataSourceErrorCode)
    def getMetrics: ZIO[
      Any,
      AwsError,
      zio.aws.kendra.model.DataSourceSyncJobMetrics.ReadOnly
    ] = AwsError.unwrapOptionField("metrics", metrics)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kendra.model.DataSourceSyncJob
  ) extends zio.aws.kendra.model.DataSourceSyncJob.ReadOnly {
    override val executionId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.executionId())
      .map(value => value: String)
    override val startTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.startTime())
      .map(value => zio.aws.kendra.model.primitives.Timestamp(value))
    override val endTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.endTime())
      .map(value => zio.aws.kendra.model.primitives.Timestamp(value))
    override val status
        : Optional[zio.aws.kendra.model.DataSourceSyncJobStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.kendra.model.DataSourceSyncJobStatus.wrap(value))
    override val errorMessage: Optional[ErrorMessage] = zio.aws.core.internal
      .optionalFromNullable(impl.errorMessage())
      .map(value => zio.aws.kendra.model.primitives.ErrorMessage(value))
    override val errorCode: Optional[zio.aws.kendra.model.ErrorCode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.errorCode())
        .map(value => zio.aws.kendra.model.ErrorCode.wrap(value))
    override val dataSourceErrorCode: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.dataSourceErrorCode())
      .map(value => value: String)
    override val metrics
        : Optional[zio.aws.kendra.model.DataSourceSyncJobMetrics.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.metrics())
        .map(value => zio.aws.kendra.model.DataSourceSyncJobMetrics.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kendra.model.DataSourceSyncJob
  ): zio.aws.kendra.model.DataSourceSyncJob.ReadOnly = new Wrapper(impl)
}
