package zio.aws.kendra.model
import scala.jdk.CollectionConverters._
sealed trait DataSourceSyncJobStatus {
  def unwrap
      : software.amazon.awssdk.services.kendra.model.DataSourceSyncJobStatus
}
object DataSourceSyncJobStatus {
  def wrap(
      value: software.amazon.awssdk.services.kendra.model.DataSourceSyncJobStatus
  ): zio.aws.kendra.model.DataSourceSyncJobStatus = value match {
    case software.amazon.awssdk.services.kendra.model.DataSourceSyncJobStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.kendra.model.DataSourceSyncJobStatus.FAILED =>
      val r = FAILED
      r
    case software.amazon.awssdk.services.kendra.model.DataSourceSyncJobStatus.SUCCEEDED =>
      val r = SUCCEEDED
      r
    case software.amazon.awssdk.services.kendra.model.DataSourceSyncJobStatus.SYNCING =>
      val r = SYNCING
      r
    case software.amazon.awssdk.services.kendra.model.DataSourceSyncJobStatus.INCOMPLETE =>
      val r = INCOMPLETE
      r
    case software.amazon.awssdk.services.kendra.model.DataSourceSyncJobStatus.STOPPING =>
      val r = STOPPING
      r
    case software.amazon.awssdk.services.kendra.model.DataSourceSyncJobStatus.ABORTED =>
      val r = ABORTED
      r
    case software.amazon.awssdk.services.kendra.model.DataSourceSyncJobStatus.SYNCING_INDEXING =>
      val r = SYNCING_INDEXING
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.kendra.model.DataSourceSyncJobStatus {
    override def unwrap
        : software.amazon.awssdk.services.kendra.model.DataSourceSyncJobStatus =
      software.amazon.awssdk.services.kendra.model.DataSourceSyncJobStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object FAILED extends zio.aws.kendra.model.DataSourceSyncJobStatus {
    override def unwrap
        : software.amazon.awssdk.services.kendra.model.DataSourceSyncJobStatus =
      software.amazon.awssdk.services.kendra.model.DataSourceSyncJobStatus.FAILED
  }
  case object SUCCEEDED extends zio.aws.kendra.model.DataSourceSyncJobStatus {
    override def unwrap
        : software.amazon.awssdk.services.kendra.model.DataSourceSyncJobStatus =
      software.amazon.awssdk.services.kendra.model.DataSourceSyncJobStatus.SUCCEEDED
  }
  case object SYNCING extends zio.aws.kendra.model.DataSourceSyncJobStatus {
    override def unwrap
        : software.amazon.awssdk.services.kendra.model.DataSourceSyncJobStatus =
      software.amazon.awssdk.services.kendra.model.DataSourceSyncJobStatus.SYNCING
  }
  case object INCOMPLETE extends zio.aws.kendra.model.DataSourceSyncJobStatus {
    override def unwrap
        : software.amazon.awssdk.services.kendra.model.DataSourceSyncJobStatus =
      software.amazon.awssdk.services.kendra.model.DataSourceSyncJobStatus.INCOMPLETE
  }
  case object STOPPING extends zio.aws.kendra.model.DataSourceSyncJobStatus {
    override def unwrap
        : software.amazon.awssdk.services.kendra.model.DataSourceSyncJobStatus =
      software.amazon.awssdk.services.kendra.model.DataSourceSyncJobStatus.STOPPING
  }
  case object ABORTED extends zio.aws.kendra.model.DataSourceSyncJobStatus {
    override def unwrap
        : software.amazon.awssdk.services.kendra.model.DataSourceSyncJobStatus =
      software.amazon.awssdk.services.kendra.model.DataSourceSyncJobStatus.ABORTED
  }
  case object SYNCING_INDEXING
      extends zio.aws.kendra.model.DataSourceSyncJobStatus {
    override def unwrap
        : software.amazon.awssdk.services.kendra.model.DataSourceSyncJobStatus =
      software.amazon.awssdk.services.kendra.model.DataSourceSyncJobStatus.SYNCING_INDEXING
  }
}
