package zio.aws.kendra.model
import zio.ZIO
import zio.aws.kendra.model.primitives.{
  IndexFieldName,
  DataSourceDateFieldFormat,
  DataSourceFieldName
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DataSourceToIndexFieldMapping(
    dataSourceFieldName: DataSourceFieldName,
    dateFieldFormat: Optional[DataSourceDateFieldFormat] = Optional.Absent,
    indexFieldName: IndexFieldName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kendra.model.DataSourceToIndexFieldMapping = {
    import DataSourceToIndexFieldMapping.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kendra.model.DataSourceToIndexFieldMapping
      .builder()
      .dataSourceFieldName(
        DataSourceFieldName.unwrap(dataSourceFieldName): java.lang.String
      )
      .optionallyWith(
        dateFieldFormat.map(value =>
          DataSourceDateFieldFormat.unwrap(value): java.lang.String
        )
      )(_.dateFieldFormat)
      .indexFieldName(IndexFieldName.unwrap(indexFieldName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.kendra.model.DataSourceToIndexFieldMapping.ReadOnly =
    zio.aws.kendra.model.DataSourceToIndexFieldMapping.wrap(buildAwsValue())
}
object DataSourceToIndexFieldMapping {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kendra.model.DataSourceToIndexFieldMapping
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kendra.model.DataSourceToIndexFieldMapping =
      zio.aws.kendra.model.DataSourceToIndexFieldMapping(
        dataSourceFieldName,
        dateFieldFormat.map(value => value),
        indexFieldName
      )
    def dataSourceFieldName: DataSourceFieldName
    def dateFieldFormat: Optional[DataSourceDateFieldFormat]
    def indexFieldName: IndexFieldName
    def getDataSourceFieldName: ZIO[Any, Nothing, DataSourceFieldName] =
      ZIO.succeed(dataSourceFieldName)
    def getDateFieldFormat: ZIO[Any, AwsError, DataSourceDateFieldFormat] =
      AwsError.unwrapOptionField("dateFieldFormat", dateFieldFormat)
    def getIndexFieldName: ZIO[Any, Nothing, IndexFieldName] =
      ZIO.succeed(indexFieldName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kendra.model.DataSourceToIndexFieldMapping
  ) extends zio.aws.kendra.model.DataSourceToIndexFieldMapping.ReadOnly {
    override val dataSourceFieldName: DataSourceFieldName =
      zio.aws.kendra.model.primitives
        .DataSourceFieldName(impl.dataSourceFieldName())
    override val dateFieldFormat: Optional[DataSourceDateFieldFormat] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dateFieldFormat())
        .map(value =>
          zio.aws.kendra.model.primitives.DataSourceDateFieldFormat(value)
        )
    override val indexFieldName: IndexFieldName =
      zio.aws.kendra.model.primitives.IndexFieldName(impl.indexFieldName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.kendra.model.DataSourceToIndexFieldMapping
  ): zio.aws.kendra.model.DataSourceToIndexFieldMapping.ReadOnly = new Wrapper(
    impl
  )
}
