package zio.aws.kendra.model
import zio.ZIO
import zio.aws.kendra.model.primitives.{VpcSecurityGroupId, SubnetId}
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DataSourceVpcConfiguration(
    subnetIds: Iterable[SubnetId],
    securityGroupIds: Iterable[VpcSecurityGroupId]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kendra.model.DataSourceVpcConfiguration = {
    import DataSourceVpcConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kendra.model.DataSourceVpcConfiguration
      .builder()
      .subnetIds(subnetIds.map { item =>
        SubnetId.unwrap(item): java.lang.String
      }.asJavaCollection)
      .securityGroupIds(securityGroupIds.map { item =>
        VpcSecurityGroupId.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.kendra.model.DataSourceVpcConfiguration.ReadOnly =
    zio.aws.kendra.model.DataSourceVpcConfiguration.wrap(buildAwsValue())
}
object DataSourceVpcConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kendra.model.DataSourceVpcConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kendra.model.DataSourceVpcConfiguration =
      zio.aws.kendra.model
        .DataSourceVpcConfiguration(subnetIds, securityGroupIds)
    def subnetIds: List[SubnetId]
    def securityGroupIds: List[VpcSecurityGroupId]
    def getSubnetIds: ZIO[Any, Nothing, List[SubnetId]] = ZIO.succeed(subnetIds)
    def getSecurityGroupIds: ZIO[Any, Nothing, List[VpcSecurityGroupId]] =
      ZIO.succeed(securityGroupIds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kendra.model.DataSourceVpcConfiguration
  ) extends zio.aws.kendra.model.DataSourceVpcConfiguration.ReadOnly {
    override val subnetIds: List[SubnetId] = impl
      .subnetIds()
      .asScala
      .map { item =>
        zio.aws.kendra.model.primitives.SubnetId(item)
      }
      .toList
    override val securityGroupIds: List[VpcSecurityGroupId] = impl
      .securityGroupIds()
      .asScala
      .map { item =>
        zio.aws.kendra.model.primitives.VpcSecurityGroupId(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.kendra.model.DataSourceVpcConfiguration
  ): zio.aws.kendra.model.DataSourceVpcConfiguration.ReadOnly = new Wrapper(
    impl
  )
}
