package zio.aws.kendra.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.kendra.model.primitives.{
  IndexName,
  ErrorMessage,
  RoleArn,
  Timestamp,
  IndexId,
  Description
}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class DescribeIndexResponse(
    name: Optional[IndexName] = Optional.Absent,
    id: Optional[IndexId] = Optional.Absent,
    edition: Optional[zio.aws.kendra.model.IndexEdition] = Optional.Absent,
    roleArn: Optional[RoleArn] = Optional.Absent,
    serverSideEncryptionConfiguration: Optional[
      zio.aws.kendra.model.ServerSideEncryptionConfiguration
    ] = Optional.Absent,
    status: Optional[zio.aws.kendra.model.IndexStatus] = Optional.Absent,
    description: Optional[Description] = Optional.Absent,
    createdAt: Optional[Timestamp] = Optional.Absent,
    updatedAt: Optional[Timestamp] = Optional.Absent,
    documentMetadataConfigurations: Optional[
      Iterable[zio.aws.kendra.model.DocumentMetadataConfiguration]
    ] = Optional.Absent,
    indexStatistics: Optional[zio.aws.kendra.model.IndexStatistics] =
      Optional.Absent,
    errorMessage: Optional[ErrorMessage] = Optional.Absent,
    capacityUnits: Optional[zio.aws.kendra.model.CapacityUnitsConfiguration] =
      Optional.Absent,
    userTokenConfigurations: Optional[
      Iterable[zio.aws.kendra.model.UserTokenConfiguration]
    ] = Optional.Absent,
    userContextPolicy: Optional[zio.aws.kendra.model.UserContextPolicy] =
      Optional.Absent,
    userGroupResolutionConfiguration: Optional[
      zio.aws.kendra.model.UserGroupResolutionConfiguration
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kendra.model.DescribeIndexResponse = {
    import DescribeIndexResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kendra.model.DescribeIndexResponse
      .builder()
      .optionallyWith(
        name.map(value => IndexName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(id.map(value => IndexId.unwrap(value): java.lang.String))(
        _.id
      )
      .optionallyWith(edition.map(value => value.unwrap))(_.edition)
      .optionallyWith(
        roleArn.map(value => RoleArn.unwrap(value): java.lang.String)
      )(_.roleArn)
      .optionallyWith(
        serverSideEncryptionConfiguration.map(value => value.buildAwsValue())
      )(_.serverSideEncryptionConfiguration)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(createdAt.map(value => Timestamp.unwrap(value): Instant))(
        _.createdAt
      )
      .optionallyWith(updatedAt.map(value => Timestamp.unwrap(value): Instant))(
        _.updatedAt
      )
      .optionallyWith(
        documentMetadataConfigurations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.documentMetadataConfigurations)
      .optionallyWith(indexStatistics.map(value => value.buildAwsValue()))(
        _.indexStatistics
      )
      .optionallyWith(
        errorMessage.map(value => ErrorMessage.unwrap(value): java.lang.String)
      )(_.errorMessage)
      .optionallyWith(capacityUnits.map(value => value.buildAwsValue()))(
        _.capacityUnits
      )
      .optionallyWith(
        userTokenConfigurations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.userTokenConfigurations)
      .optionallyWith(userContextPolicy.map(value => value.unwrap))(
        _.userContextPolicy
      )
      .optionallyWith(
        userGroupResolutionConfiguration.map(value => value.buildAwsValue())
      )(_.userGroupResolutionConfiguration)
      .build()
  }
  def asReadOnly: zio.aws.kendra.model.DescribeIndexResponse.ReadOnly =
    zio.aws.kendra.model.DescribeIndexResponse.wrap(buildAwsValue())
}
object DescribeIndexResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kendra.model.DescribeIndexResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kendra.model.DescribeIndexResponse =
      zio.aws.kendra.model.DescribeIndexResponse(
        name.map(value => value),
        id.map(value => value),
        edition.map(value => value),
        roleArn.map(value => value),
        serverSideEncryptionConfiguration.map(value => value.asEditable),
        status.map(value => value),
        description.map(value => value),
        createdAt.map(value => value),
        updatedAt.map(value => value),
        documentMetadataConfigurations.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        indexStatistics.map(value => value.asEditable),
        errorMessage.map(value => value),
        capacityUnits.map(value => value.asEditable),
        userTokenConfigurations.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        userContextPolicy.map(value => value),
        userGroupResolutionConfiguration.map(value => value.asEditable)
      )
    def name: Optional[IndexName]
    def id: Optional[IndexId]
    def edition: Optional[zio.aws.kendra.model.IndexEdition]
    def roleArn: Optional[RoleArn]
    def serverSideEncryptionConfiguration: Optional[
      zio.aws.kendra.model.ServerSideEncryptionConfiguration.ReadOnly
    ]
    def status: Optional[zio.aws.kendra.model.IndexStatus]
    def description: Optional[Description]
    def createdAt: Optional[Timestamp]
    def updatedAt: Optional[Timestamp]
    def documentMetadataConfigurations: Optional[
      List[zio.aws.kendra.model.DocumentMetadataConfiguration.ReadOnly]
    ]
    def indexStatistics: Optional[zio.aws.kendra.model.IndexStatistics.ReadOnly]
    def errorMessage: Optional[ErrorMessage]
    def capacityUnits
        : Optional[zio.aws.kendra.model.CapacityUnitsConfiguration.ReadOnly]
    def userTokenConfigurations
        : Optional[List[zio.aws.kendra.model.UserTokenConfiguration.ReadOnly]]
    def userContextPolicy: Optional[zio.aws.kendra.model.UserContextPolicy]
    def userGroupResolutionConfiguration: Optional[
      zio.aws.kendra.model.UserGroupResolutionConfiguration.ReadOnly
    ]
    def getName: ZIO[Any, AwsError, IndexName] =
      AwsError.unwrapOptionField("name", name)
    def getId: ZIO[Any, AwsError, IndexId] =
      AwsError.unwrapOptionField("id", id)
    def getEdition: ZIO[Any, AwsError, zio.aws.kendra.model.IndexEdition] =
      AwsError.unwrapOptionField("edition", edition)
    def getRoleArn: ZIO[Any, AwsError, RoleArn] =
      AwsError.unwrapOptionField("roleArn", roleArn)
    def getServerSideEncryptionConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.kendra.model.ServerSideEncryptionConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "serverSideEncryptionConfiguration",
      serverSideEncryptionConfiguration
    )
    def getStatus: ZIO[Any, AwsError, zio.aws.kendra.model.IndexStatus] =
      AwsError.unwrapOptionField("status", status)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getCreatedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getUpdatedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("updatedAt", updatedAt)
    def getDocumentMetadataConfigurations: ZIO[Any, AwsError, List[
      zio.aws.kendra.model.DocumentMetadataConfiguration.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "documentMetadataConfigurations",
      documentMetadataConfigurations
    )
    def getIndexStatistics
        : ZIO[Any, AwsError, zio.aws.kendra.model.IndexStatistics.ReadOnly] =
      AwsError.unwrapOptionField("indexStatistics", indexStatistics)
    def getErrorMessage: ZIO[Any, AwsError, ErrorMessage] =
      AwsError.unwrapOptionField("errorMessage", errorMessage)
    def getCapacityUnits: ZIO[
      Any,
      AwsError,
      zio.aws.kendra.model.CapacityUnitsConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("capacityUnits", capacityUnits)
    def getUserTokenConfigurations: ZIO[Any, AwsError, List[
      zio.aws.kendra.model.UserTokenConfiguration.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "userTokenConfigurations",
      userTokenConfigurations
    )
    def getUserContextPolicy
        : ZIO[Any, AwsError, zio.aws.kendra.model.UserContextPolicy] =
      AwsError.unwrapOptionField("userContextPolicy", userContextPolicy)
    def getUserGroupResolutionConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.kendra.model.UserGroupResolutionConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "userGroupResolutionConfiguration",
      userGroupResolutionConfiguration
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kendra.model.DescribeIndexResponse
  ) extends zio.aws.kendra.model.DescribeIndexResponse.ReadOnly {
    override val name: Optional[IndexName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.kendra.model.primitives.IndexName(value))
    override val id: Optional[IndexId] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value => zio.aws.kendra.model.primitives.IndexId(value))
    override val edition: Optional[zio.aws.kendra.model.IndexEdition] =
      zio.aws.core.internal
        .optionalFromNullable(impl.edition())
        .map(value => zio.aws.kendra.model.IndexEdition.wrap(value))
    override val roleArn: Optional[RoleArn] = zio.aws.core.internal
      .optionalFromNullable(impl.roleArn())
      .map(value => zio.aws.kendra.model.primitives.RoleArn(value))
    override val serverSideEncryptionConfiguration: Optional[
      zio.aws.kendra.model.ServerSideEncryptionConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.serverSideEncryptionConfiguration())
      .map(value =>
        zio.aws.kendra.model.ServerSideEncryptionConfiguration.wrap(value)
      )
    override val status: Optional[zio.aws.kendra.model.IndexStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.kendra.model.IndexStatus.wrap(value))
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.kendra.model.primitives.Description(value))
    override val createdAt: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.createdAt())
      .map(value => zio.aws.kendra.model.primitives.Timestamp(value))
    override val updatedAt: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.updatedAt())
      .map(value => zio.aws.kendra.model.primitives.Timestamp(value))
    override val documentMetadataConfigurations: Optional[
      List[zio.aws.kendra.model.DocumentMetadataConfiguration.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.documentMetadataConfigurations())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.kendra.model.DocumentMetadataConfiguration.wrap(item)
        }.toList
      )
    override val indexStatistics
        : Optional[zio.aws.kendra.model.IndexStatistics.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.indexStatistics())
        .map(value => zio.aws.kendra.model.IndexStatistics.wrap(value))
    override val errorMessage: Optional[ErrorMessage] = zio.aws.core.internal
      .optionalFromNullable(impl.errorMessage())
      .map(value => zio.aws.kendra.model.primitives.ErrorMessage(value))
    override val capacityUnits
        : Optional[zio.aws.kendra.model.CapacityUnitsConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.capacityUnits())
        .map(value =>
          zio.aws.kendra.model.CapacityUnitsConfiguration.wrap(value)
        )
    override val userTokenConfigurations
        : Optional[List[zio.aws.kendra.model.UserTokenConfiguration.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.userTokenConfigurations())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.kendra.model.UserTokenConfiguration.wrap(item)
          }.toList
        )
    override val userContextPolicy
        : Optional[zio.aws.kendra.model.UserContextPolicy] =
      zio.aws.core.internal
        .optionalFromNullable(impl.userContextPolicy())
        .map(value => zio.aws.kendra.model.UserContextPolicy.wrap(value))
    override val userGroupResolutionConfiguration: Optional[
      zio.aws.kendra.model.UserGroupResolutionConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.userGroupResolutionConfiguration())
      .map(value =>
        zio.aws.kendra.model.UserGroupResolutionConfiguration.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.kendra.model.DescribeIndexResponse
  ): zio.aws.kendra.model.DescribeIndexResponse.ReadOnly = new Wrapper(impl)
}
