package zio.aws.kendra.model
import zio.ZIO
import zio.aws.kendra.model.primitives.DocumentMetadataConfigurationName
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DocumentRelevanceConfiguration(
    name: DocumentMetadataConfigurationName,
    relevance: zio.aws.kendra.model.Relevance
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kendra.model.DocumentRelevanceConfiguration = {
    import DocumentRelevanceConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kendra.model.DocumentRelevanceConfiguration
      .builder()
      .name(DocumentMetadataConfigurationName.unwrap(name): java.lang.String)
      .relevance(relevance.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.kendra.model.DocumentRelevanceConfiguration.ReadOnly =
    zio.aws.kendra.model.DocumentRelevanceConfiguration.wrap(buildAwsValue())
}
object DocumentRelevanceConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kendra.model.DocumentRelevanceConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kendra.model.DocumentRelevanceConfiguration =
      zio.aws.kendra.model
        .DocumentRelevanceConfiguration(name, relevance.asEditable)
    def name: DocumentMetadataConfigurationName
    def relevance: zio.aws.kendra.model.Relevance.ReadOnly
    def getName: ZIO[Any, Nothing, DocumentMetadataConfigurationName] =
      ZIO.succeed(name)
    def getRelevance
        : ZIO[Any, Nothing, zio.aws.kendra.model.Relevance.ReadOnly] =
      ZIO.succeed(relevance)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kendra.model.DocumentRelevanceConfiguration
  ) extends zio.aws.kendra.model.DocumentRelevanceConfiguration.ReadOnly {
    override val name: DocumentMetadataConfigurationName =
      zio.aws.kendra.model.primitives
        .DocumentMetadataConfigurationName(impl.name())
    override val relevance: zio.aws.kendra.model.Relevance.ReadOnly =
      zio.aws.kendra.model.Relevance.wrap(impl.relevance())
  }
  def wrap(
      impl: software.amazon.awssdk.services.kendra.model.DocumentRelevanceConfiguration
  ): zio.aws.kendra.model.DocumentRelevanceConfiguration.ReadOnly = new Wrapper(
    impl
  )
}
