package zio.aws.kendra.model
import zio.ZIO
import zio.aws.kendra.model.primitives.EntityId
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class EntityPersonaConfiguration(
    entityId: EntityId,
    persona: zio.aws.kendra.model.Persona
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kendra.model.EntityPersonaConfiguration = {
    import EntityPersonaConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kendra.model.EntityPersonaConfiguration
      .builder()
      .entityId(EntityId.unwrap(entityId): java.lang.String)
      .persona(persona.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.kendra.model.EntityPersonaConfiguration.ReadOnly =
    zio.aws.kendra.model.EntityPersonaConfiguration.wrap(buildAwsValue())
}
object EntityPersonaConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kendra.model.EntityPersonaConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kendra.model.EntityPersonaConfiguration =
      zio.aws.kendra.model.EntityPersonaConfiguration(entityId, persona)
    def entityId: EntityId
    def persona: zio.aws.kendra.model.Persona
    def getEntityId: ZIO[Any, Nothing, EntityId] = ZIO.succeed(entityId)
    def getPersona: ZIO[Any, Nothing, zio.aws.kendra.model.Persona] =
      ZIO.succeed(persona)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kendra.model.EntityPersonaConfiguration
  ) extends zio.aws.kendra.model.EntityPersonaConfiguration.ReadOnly {
    override val entityId: EntityId =
      zio.aws.kendra.model.primitives.EntityId(impl.entityId())
    override val persona: zio.aws.kendra.model.Persona =
      zio.aws.kendra.model.Persona.wrap(impl.persona())
  }
  def wrap(
      impl: software.amazon.awssdk.services.kendra.model.EntityPersonaConfiguration
  ): zio.aws.kendra.model.EntityPersonaConfiguration.ReadOnly = new Wrapper(
    impl
  )
}
