package zio.aws.kendra.model
import java.lang.Integer
import zio.ZIO
import zio.aws.kendra.model.primitives.IndexedQuestionAnswersCount
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class FaqStatistics(
    indexedQuestionAnswersCount: IndexedQuestionAnswersCount
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kendra.model.FaqStatistics = {
    import FaqStatistics.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kendra.model.FaqStatistics
      .builder()
      .indexedQuestionAnswersCount(
        IndexedQuestionAnswersCount.unwrap(indexedQuestionAnswersCount): Integer
      )
      .build()
  }
  def asReadOnly: zio.aws.kendra.model.FaqStatistics.ReadOnly =
    zio.aws.kendra.model.FaqStatistics.wrap(buildAwsValue())
}
object FaqStatistics {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kendra.model.FaqStatistics
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kendra.model.FaqStatistics =
      zio.aws.kendra.model.FaqStatistics(indexedQuestionAnswersCount)
    def indexedQuestionAnswersCount: IndexedQuestionAnswersCount
    def getIndexedQuestionAnswersCount
        : ZIO[Any, Nothing, IndexedQuestionAnswersCount] =
      ZIO.succeed(indexedQuestionAnswersCount)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kendra.model.FaqStatistics
  ) extends zio.aws.kendra.model.FaqStatistics.ReadOnly {
    override val indexedQuestionAnswersCount: IndexedQuestionAnswersCount =
      zio.aws.kendra.model.primitives
        .IndexedQuestionAnswersCount(impl.indexedQuestionAnswersCount())
  }
  def wrap(
      impl: software.amazon.awssdk.services.kendra.model.FaqStatistics
  ): zio.aws.kendra.model.FaqStatistics.ReadOnly = new Wrapper(impl)
}
