package zio.aws.kendra.model
import scala.jdk.CollectionConverters._
sealed trait FsxFileSystemType {
  def unwrap: software.amazon.awssdk.services.kendra.model.FsxFileSystemType
}
object FsxFileSystemType {
  def wrap(
      value: software.amazon.awssdk.services.kendra.model.FsxFileSystemType
  ): zio.aws.kendra.model.FsxFileSystemType = value match {
    case software.amazon.awssdk.services.kendra.model.FsxFileSystemType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.kendra.model.FsxFileSystemType.WINDOWS =>
      val r = WINDOWS
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.kendra.model.FsxFileSystemType {
    override def unwrap
        : software.amazon.awssdk.services.kendra.model.FsxFileSystemType =
      software.amazon.awssdk.services.kendra.model.FsxFileSystemType.UNKNOWN_TO_SDK_VERSION
  }
  case object WINDOWS extends zio.aws.kendra.model.FsxFileSystemType {
    override def unwrap
        : software.amazon.awssdk.services.kendra.model.FsxFileSystemType =
      software.amazon.awssdk.services.kendra.model.FsxFileSystemType.WINDOWS
  }
}
