package zio.aws.kendra.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GitHubDocumentCrawlProperties(
    crawlRepositoryDocuments: Optional[Boolean] = Optional.Absent,
    crawlIssue: Optional[Boolean] = Optional.Absent,
    crawlIssueComment: Optional[Boolean] = Optional.Absent,
    crawlIssueCommentAttachment: Optional[Boolean] = Optional.Absent,
    crawlPullRequest: Optional[Boolean] = Optional.Absent,
    crawlPullRequestComment: Optional[Boolean] = Optional.Absent,
    crawlPullRequestCommentAttachment: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kendra.model.GitHubDocumentCrawlProperties = {
    import GitHubDocumentCrawlProperties.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kendra.model.GitHubDocumentCrawlProperties
      .builder()
      .optionallyWith(
        crawlRepositoryDocuments.map(value => value: java.lang.Boolean)
      )(_.crawlRepositoryDocuments)
      .optionallyWith(crawlIssue.map(value => value: java.lang.Boolean))(
        _.crawlIssue
      )
      .optionallyWith(crawlIssueComment.map(value => value: java.lang.Boolean))(
        _.crawlIssueComment
      )
      .optionallyWith(
        crawlIssueCommentAttachment.map(value => value: java.lang.Boolean)
      )(_.crawlIssueCommentAttachment)
      .optionallyWith(crawlPullRequest.map(value => value: java.lang.Boolean))(
        _.crawlPullRequest
      )
      .optionallyWith(
        crawlPullRequestComment.map(value => value: java.lang.Boolean)
      )(_.crawlPullRequestComment)
      .optionallyWith(
        crawlPullRequestCommentAttachment.map(value => value: java.lang.Boolean)
      )(_.crawlPullRequestCommentAttachment)
      .build()
  }
  def asReadOnly: zio.aws.kendra.model.GitHubDocumentCrawlProperties.ReadOnly =
    zio.aws.kendra.model.GitHubDocumentCrawlProperties.wrap(buildAwsValue())
}
object GitHubDocumentCrawlProperties {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kendra.model.GitHubDocumentCrawlProperties
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kendra.model.GitHubDocumentCrawlProperties =
      zio.aws.kendra.model.GitHubDocumentCrawlProperties(
        crawlRepositoryDocuments.map(value => value),
        crawlIssue.map(value => value),
        crawlIssueComment.map(value => value),
        crawlIssueCommentAttachment.map(value => value),
        crawlPullRequest.map(value => value),
        crawlPullRequestComment.map(value => value),
        crawlPullRequestCommentAttachment.map(value => value)
      )
    def crawlRepositoryDocuments: Optional[Boolean]
    def crawlIssue: Optional[Boolean]
    def crawlIssueComment: Optional[Boolean]
    def crawlIssueCommentAttachment: Optional[Boolean]
    def crawlPullRequest: Optional[Boolean]
    def crawlPullRequestComment: Optional[Boolean]
    def crawlPullRequestCommentAttachment: Optional[Boolean]
    def getCrawlRepositoryDocuments: ZIO[Any, AwsError, Boolean] = AwsError
      .unwrapOptionField("crawlRepositoryDocuments", crawlRepositoryDocuments)
    def getCrawlIssue: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("crawlIssue", crawlIssue)
    def getCrawlIssueComment: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("crawlIssueComment", crawlIssueComment)
    def getCrawlIssueCommentAttachment: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField(
        "crawlIssueCommentAttachment",
        crawlIssueCommentAttachment
      )
    def getCrawlPullRequest: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("crawlPullRequest", crawlPullRequest)
    def getCrawlPullRequestComment: ZIO[Any, AwsError, Boolean] = AwsError
      .unwrapOptionField("crawlPullRequestComment", crawlPullRequestComment)
    def getCrawlPullRequestCommentAttachment: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField(
        "crawlPullRequestCommentAttachment",
        crawlPullRequestCommentAttachment
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kendra.model.GitHubDocumentCrawlProperties
  ) extends zio.aws.kendra.model.GitHubDocumentCrawlProperties.ReadOnly {
    override val crawlRepositoryDocuments: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.crawlRepositoryDocuments())
        .map(value => value: Boolean)
    override val crawlIssue: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.crawlIssue())
      .map(value => value: Boolean)
    override val crawlIssueComment: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.crawlIssueComment())
      .map(value => value: Boolean)
    override val crawlIssueCommentAttachment: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.crawlIssueCommentAttachment())
        .map(value => value: Boolean)
    override val crawlPullRequest: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.crawlPullRequest())
      .map(value => value: Boolean)
    override val crawlPullRequestComment: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.crawlPullRequestComment())
        .map(value => value: Boolean)
    override val crawlPullRequestCommentAttachment: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.crawlPullRequestCommentAttachment())
        .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.kendra.model.GitHubDocumentCrawlProperties
  ): zio.aws.kendra.model.GitHubDocumentCrawlProperties.ReadOnly = new Wrapper(
    impl
  )
}
