package zio.aws.kendra.model
import zio.ZIO
import zio.aws.kendra.model.primitives.{
  MimeType,
  SecretArn,
  UserAccount,
  SharedDriveId,
  DataSourceInclusionsExclusionsStringsMember
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GoogleDriveConfiguration(
    secretArn: SecretArn,
    inclusionPatterns: Optional[
      Iterable[DataSourceInclusionsExclusionsStringsMember]
    ] = Optional.Absent,
    exclusionPatterns: Optional[
      Iterable[DataSourceInclusionsExclusionsStringsMember]
    ] = Optional.Absent,
    fieldMappings: Optional[
      Iterable[zio.aws.kendra.model.DataSourceToIndexFieldMapping]
    ] = Optional.Absent,
    excludeMimeTypes: Optional[Iterable[MimeType]] = Optional.Absent,
    excludeUserAccounts: Optional[Iterable[UserAccount]] = Optional.Absent,
    excludeSharedDrives: Optional[Iterable[SharedDriveId]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kendra.model.GoogleDriveConfiguration = {
    import GoogleDriveConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kendra.model.GoogleDriveConfiguration
      .builder()
      .secretArn(SecretArn.unwrap(secretArn): java.lang.String)
      .optionallyWith(
        inclusionPatterns.map(value =>
          value.map { item =>
            DataSourceInclusionsExclusionsStringsMember.unwrap(
              item
            ): java.lang.String
          }.asJavaCollection
        )
      )(_.inclusionPatterns)
      .optionallyWith(
        exclusionPatterns.map(value =>
          value.map { item =>
            DataSourceInclusionsExclusionsStringsMember.unwrap(
              item
            ): java.lang.String
          }.asJavaCollection
        )
      )(_.exclusionPatterns)
      .optionallyWith(
        fieldMappings.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.fieldMappings)
      .optionallyWith(
        excludeMimeTypes.map(value =>
          value.map { item =>
            MimeType.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.excludeMimeTypes)
      .optionallyWith(
        excludeUserAccounts.map(value =>
          value.map { item =>
            UserAccount.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.excludeUserAccounts)
      .optionallyWith(
        excludeSharedDrives.map(value =>
          value.map { item =>
            SharedDriveId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.excludeSharedDrives)
      .build()
  }
  def asReadOnly: zio.aws.kendra.model.GoogleDriveConfiguration.ReadOnly =
    zio.aws.kendra.model.GoogleDriveConfiguration.wrap(buildAwsValue())
}
object GoogleDriveConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kendra.model.GoogleDriveConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kendra.model.GoogleDriveConfiguration =
      zio.aws.kendra.model.GoogleDriveConfiguration(
        secretArn,
        inclusionPatterns.map(value => value),
        exclusionPatterns.map(value => value),
        fieldMappings.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        excludeMimeTypes.map(value => value),
        excludeUserAccounts.map(value => value),
        excludeSharedDrives.map(value => value)
      )
    def secretArn: SecretArn
    def inclusionPatterns
        : Optional[List[DataSourceInclusionsExclusionsStringsMember]]
    def exclusionPatterns
        : Optional[List[DataSourceInclusionsExclusionsStringsMember]]
    def fieldMappings: Optional[
      List[zio.aws.kendra.model.DataSourceToIndexFieldMapping.ReadOnly]
    ]
    def excludeMimeTypes: Optional[List[MimeType]]
    def excludeUserAccounts: Optional[List[UserAccount]]
    def excludeSharedDrives: Optional[List[SharedDriveId]]
    def getSecretArn: ZIO[Any, Nothing, SecretArn] = ZIO.succeed(secretArn)
    def getInclusionPatterns: ZIO[Any, AwsError, List[
      DataSourceInclusionsExclusionsStringsMember
    ]] = AwsError.unwrapOptionField("inclusionPatterns", inclusionPatterns)
    def getExclusionPatterns: ZIO[Any, AwsError, List[
      DataSourceInclusionsExclusionsStringsMember
    ]] = AwsError.unwrapOptionField("exclusionPatterns", exclusionPatterns)
    def getFieldMappings: ZIO[Any, AwsError, List[
      zio.aws.kendra.model.DataSourceToIndexFieldMapping.ReadOnly
    ]] = AwsError.unwrapOptionField("fieldMappings", fieldMappings)
    def getExcludeMimeTypes: ZIO[Any, AwsError, List[MimeType]] =
      AwsError.unwrapOptionField("excludeMimeTypes", excludeMimeTypes)
    def getExcludeUserAccounts: ZIO[Any, AwsError, List[UserAccount]] =
      AwsError.unwrapOptionField("excludeUserAccounts", excludeUserAccounts)
    def getExcludeSharedDrives: ZIO[Any, AwsError, List[SharedDriveId]] =
      AwsError.unwrapOptionField("excludeSharedDrives", excludeSharedDrives)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kendra.model.GoogleDriveConfiguration
  ) extends zio.aws.kendra.model.GoogleDriveConfiguration.ReadOnly {
    override val secretArn: SecretArn =
      zio.aws.kendra.model.primitives.SecretArn(impl.secretArn())
    override val inclusionPatterns
        : Optional[List[DataSourceInclusionsExclusionsStringsMember]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.inclusionPatterns())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.kendra.model.primitives
              .DataSourceInclusionsExclusionsStringsMember(item)
          }.toList
        )
    override val exclusionPatterns
        : Optional[List[DataSourceInclusionsExclusionsStringsMember]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.exclusionPatterns())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.kendra.model.primitives
              .DataSourceInclusionsExclusionsStringsMember(item)
          }.toList
        )
    override val fieldMappings: Optional[
      List[zio.aws.kendra.model.DataSourceToIndexFieldMapping.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.fieldMappings())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.kendra.model.DataSourceToIndexFieldMapping.wrap(item)
        }.toList
      )
    override val excludeMimeTypes: Optional[List[MimeType]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.excludeMimeTypes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.kendra.model.primitives.MimeType(item)
          }.toList
        )
    override val excludeUserAccounts: Optional[List[UserAccount]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.excludeUserAccounts())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.kendra.model.primitives.UserAccount(item)
          }.toList
        )
    override val excludeSharedDrives: Optional[List[SharedDriveId]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.excludeSharedDrives())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.kendra.model.primitives.SharedDriveId(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.kendra.model.GoogleDriveConfiguration
  ): zio.aws.kendra.model.GoogleDriveConfiguration.ReadOnly = new Wrapper(impl)
}
