package zio.aws.kendra.model
import scala.jdk.CollectionConverters._
sealed trait IndexEdition {
  def unwrap: software.amazon.awssdk.services.kendra.model.IndexEdition
}
object IndexEdition {
  def wrap(
      value: software.amazon.awssdk.services.kendra.model.IndexEdition
  ): zio.aws.kendra.model.IndexEdition = value match {
    case software.amazon.awssdk.services.kendra.model.IndexEdition.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.kendra.model.IndexEdition.DEVELOPER_EDITION =>
      val r = DEVELOPER_EDITION
      r
    case software.amazon.awssdk.services.kendra.model.IndexEdition.ENTERPRISE_EDITION =>
      val r = ENTERPRISE_EDITION
      r
  }
  case object unknownToSdkVersion extends zio.aws.kendra.model.IndexEdition {
    override def unwrap
        : software.amazon.awssdk.services.kendra.model.IndexEdition =
      software.amazon.awssdk.services.kendra.model.IndexEdition.UNKNOWN_TO_SDK_VERSION
  }
  case object DEVELOPER_EDITION extends zio.aws.kendra.model.IndexEdition {
    override def unwrap
        : software.amazon.awssdk.services.kendra.model.IndexEdition =
      software.amazon.awssdk.services.kendra.model.IndexEdition.DEVELOPER_EDITION
  }
  case object ENTERPRISE_EDITION extends zio.aws.kendra.model.IndexEdition {
    override def unwrap
        : software.amazon.awssdk.services.kendra.model.IndexEdition =
      software.amazon.awssdk.services.kendra.model.IndexEdition.ENTERPRISE_EDITION
  }
}
