package zio.aws.kendra.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class IndexStatistics(
    faqStatistics: zio.aws.kendra.model.FaqStatistics,
    textDocumentStatistics: zio.aws.kendra.model.TextDocumentStatistics
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kendra.model.IndexStatistics = {
    import IndexStatistics.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kendra.model.IndexStatistics
      .builder()
      .faqStatistics(faqStatistics.buildAwsValue())
      .textDocumentStatistics(textDocumentStatistics.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.kendra.model.IndexStatistics.ReadOnly =
    zio.aws.kendra.model.IndexStatistics.wrap(buildAwsValue())
}
object IndexStatistics {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kendra.model.IndexStatistics
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kendra.model.IndexStatistics =
      zio.aws.kendra.model.IndexStatistics(
        faqStatistics.asEditable,
        textDocumentStatistics.asEditable
      )
    def faqStatistics: zio.aws.kendra.model.FaqStatistics.ReadOnly
    def textDocumentStatistics
        : zio.aws.kendra.model.TextDocumentStatistics.ReadOnly
    def getFaqStatistics
        : ZIO[Any, Nothing, zio.aws.kendra.model.FaqStatistics.ReadOnly] =
      ZIO.succeed(faqStatistics)
    def getTextDocumentStatistics: ZIO[
      Any,
      Nothing,
      zio.aws.kendra.model.TextDocumentStatistics.ReadOnly
    ] = ZIO.succeed(textDocumentStatistics)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kendra.model.IndexStatistics
  ) extends zio.aws.kendra.model.IndexStatistics.ReadOnly {
    override val faqStatistics: zio.aws.kendra.model.FaqStatistics.ReadOnly =
      zio.aws.kendra.model.FaqStatistics.wrap(impl.faqStatistics())
    override val textDocumentStatistics
        : zio.aws.kendra.model.TextDocumentStatistics.ReadOnly =
      zio.aws.kendra.model.TextDocumentStatistics
        .wrap(impl.textDocumentStatistics())
  }
  def wrap(
      impl: software.amazon.awssdk.services.kendra.model.IndexStatistics
  ): zio.aws.kendra.model.IndexStatistics.ReadOnly = new Wrapper(impl)
}
