package zio.aws.kendra.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class JsonTokenTypeConfiguration(
    userNameAttributeField: String,
    groupAttributeField: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kendra.model.JsonTokenTypeConfiguration = {
    import JsonTokenTypeConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kendra.model.JsonTokenTypeConfiguration
      .builder()
      .userNameAttributeField(userNameAttributeField: java.lang.String)
      .groupAttributeField(groupAttributeField: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.kendra.model.JsonTokenTypeConfiguration.ReadOnly =
    zio.aws.kendra.model.JsonTokenTypeConfiguration.wrap(buildAwsValue())
}
object JsonTokenTypeConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kendra.model.JsonTokenTypeConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kendra.model.JsonTokenTypeConfiguration =
      zio.aws.kendra.model
        .JsonTokenTypeConfiguration(userNameAttributeField, groupAttributeField)
    def userNameAttributeField: String
    def groupAttributeField: String
    def getUserNameAttributeField: ZIO[Any, Nothing, String] =
      ZIO.succeed(userNameAttributeField)
    def getGroupAttributeField: ZIO[Any, Nothing, String] =
      ZIO.succeed(groupAttributeField)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kendra.model.JsonTokenTypeConfiguration
  ) extends zio.aws.kendra.model.JsonTokenTypeConfiguration.ReadOnly {
    override val userNameAttributeField: String =
      impl.userNameAttributeField(): String
    override val groupAttributeField: String =
      impl.groupAttributeField(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.kendra.model.JsonTokenTypeConfiguration
  ): zio.aws.kendra.model.JsonTokenTypeConfiguration.ReadOnly = new Wrapper(
    impl
  )
}
