package zio.aws.kendra.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.kendra.model.primitives.{
  MaxResultsIntegerForListAccessControlConfigurationsRequest,
  IndexId
}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListAccessControlConfigurationsRequest(
    indexId: IndexId,
    nextToken: Optional[String] = Optional.Absent,
    maxResults: Optional[
      MaxResultsIntegerForListAccessControlConfigurationsRequest
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kendra.model.ListAccessControlConfigurationsRequest = {
    import ListAccessControlConfigurationsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kendra.model.ListAccessControlConfigurationsRequest
      .builder()
      .indexId(IndexId.unwrap(indexId): java.lang.String)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(
        maxResults.map(value =>
          MaxResultsIntegerForListAccessControlConfigurationsRequest.unwrap(
            value
          ): Integer
        )
      )(_.maxResults)
      .build()
  }
  def asReadOnly
      : zio.aws.kendra.model.ListAccessControlConfigurationsRequest.ReadOnly =
    zio.aws.kendra.model.ListAccessControlConfigurationsRequest
      .wrap(buildAwsValue())
}
object ListAccessControlConfigurationsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kendra.model.ListAccessControlConfigurationsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.kendra.model.ListAccessControlConfigurationsRequest =
      zio.aws.kendra.model.ListAccessControlConfigurationsRequest(
        indexId,
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def indexId: IndexId
    def nextToken: Optional[String]
    def maxResults
        : Optional[MaxResultsIntegerForListAccessControlConfigurationsRequest]
    def getIndexId: ZIO[Any, Nothing, IndexId] = ZIO.succeed(indexId)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[
      Any,
      AwsError,
      MaxResultsIntegerForListAccessControlConfigurationsRequest
    ] = AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kendra.model.ListAccessControlConfigurationsRequest
  ) extends zio.aws.kendra.model.ListAccessControlConfigurationsRequest.ReadOnly {
    override val indexId: IndexId =
      zio.aws.kendra.model.primitives.IndexId(impl.indexId())
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
    override val maxResults
        : Optional[MaxResultsIntegerForListAccessControlConfigurationsRequest] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value =>
          zio.aws.kendra.model.primitives
            .MaxResultsIntegerForListAccessControlConfigurationsRequest(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.kendra.model.ListAccessControlConfigurationsRequest
  ): zio.aws.kendra.model.ListAccessControlConfigurationsRequest.ReadOnly =
    new Wrapper(impl)
}
