package zio.aws.kendra.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.kendra.model.primitives.{
  MaxResultsIntegerForListDataSourceSyncJobsRequest,
  NextToken,
  IndexId,
  DataSourceId
}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListDataSourceSyncJobsRequest(
    id: DataSourceId,
    indexId: IndexId,
    nextToken: Optional[NextToken] = Optional.Absent,
    maxResults: Optional[MaxResultsIntegerForListDataSourceSyncJobsRequest] =
      Optional.Absent,
    startTimeFilter: Optional[zio.aws.kendra.model.TimeRange] = Optional.Absent,
    statusFilter: Optional[zio.aws.kendra.model.DataSourceSyncJobStatus] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kendra.model.ListDataSourceSyncJobsRequest = {
    import ListDataSourceSyncJobsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kendra.model.ListDataSourceSyncJobsRequest
      .builder()
      .id(DataSourceId.unwrap(id): java.lang.String)
      .indexId(IndexId.unwrap(indexId): java.lang.String)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value =>
          MaxResultsIntegerForListDataSourceSyncJobsRequest.unwrap(
            value
          ): Integer
        )
      )(_.maxResults)
      .optionallyWith(startTimeFilter.map(value => value.buildAwsValue()))(
        _.startTimeFilter
      )
      .optionallyWith(statusFilter.map(value => value.unwrap))(_.statusFilter)
      .build()
  }
  def asReadOnly: zio.aws.kendra.model.ListDataSourceSyncJobsRequest.ReadOnly =
    zio.aws.kendra.model.ListDataSourceSyncJobsRequest.wrap(buildAwsValue())
}
object ListDataSourceSyncJobsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kendra.model.ListDataSourceSyncJobsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kendra.model.ListDataSourceSyncJobsRequest =
      zio.aws.kendra.model.ListDataSourceSyncJobsRequest(
        id,
        indexId,
        nextToken.map(value => value),
        maxResults.map(value => value),
        startTimeFilter.map(value => value.asEditable),
        statusFilter.map(value => value)
      )
    def id: DataSourceId
    def indexId: IndexId
    def nextToken: Optional[NextToken]
    def maxResults: Optional[MaxResultsIntegerForListDataSourceSyncJobsRequest]
    def startTimeFilter: Optional[zio.aws.kendra.model.TimeRange.ReadOnly]
    def statusFilter: Optional[zio.aws.kendra.model.DataSourceSyncJobStatus]
    def getId: ZIO[Any, Nothing, DataSourceId] = ZIO.succeed(id)
    def getIndexId: ZIO[Any, Nothing, IndexId] = ZIO.succeed(indexId)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[
      Any,
      AwsError,
      MaxResultsIntegerForListDataSourceSyncJobsRequest
    ] = AwsError.unwrapOptionField("maxResults", maxResults)
    def getStartTimeFilter
        : ZIO[Any, AwsError, zio.aws.kendra.model.TimeRange.ReadOnly] =
      AwsError.unwrapOptionField("startTimeFilter", startTimeFilter)
    def getStatusFilter
        : ZIO[Any, AwsError, zio.aws.kendra.model.DataSourceSyncJobStatus] =
      AwsError.unwrapOptionField("statusFilter", statusFilter)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kendra.model.ListDataSourceSyncJobsRequest
  ) extends zio.aws.kendra.model.ListDataSourceSyncJobsRequest.ReadOnly {
    override val id: DataSourceId =
      zio.aws.kendra.model.primitives.DataSourceId(impl.id())
    override val indexId: IndexId =
      zio.aws.kendra.model.primitives.IndexId(impl.indexId())
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.kendra.model.primitives.NextToken(value))
    override val maxResults
        : Optional[MaxResultsIntegerForListDataSourceSyncJobsRequest] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value =>
          zio.aws.kendra.model.primitives
            .MaxResultsIntegerForListDataSourceSyncJobsRequest(value)
        )
    override val startTimeFilter
        : Optional[zio.aws.kendra.model.TimeRange.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.startTimeFilter())
        .map(value => zio.aws.kendra.model.TimeRange.wrap(value))
    override val statusFilter
        : Optional[zio.aws.kendra.model.DataSourceSyncJobStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.statusFilter())
        .map(value => zio.aws.kendra.model.DataSourceSyncJobStatus.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kendra.model.ListDataSourceSyncJobsRequest
  ): zio.aws.kendra.model.ListDataSourceSyncJobsRequest.ReadOnly = new Wrapper(
    impl
  )
}
