package zio.aws.kendra.model
import zio.ZIO
import zio.aws.kendra.model.primitives.NextToken
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListDataSourcesResponse(
    summaryItems: Optional[Iterable[zio.aws.kendra.model.DataSourceSummary]] =
      Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kendra.model.ListDataSourcesResponse = {
    import ListDataSourcesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kendra.model.ListDataSourcesResponse
      .builder()
      .optionallyWith(
        summaryItems.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.summaryItems)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.kendra.model.ListDataSourcesResponse.ReadOnly =
    zio.aws.kendra.model.ListDataSourcesResponse.wrap(buildAwsValue())
}
object ListDataSourcesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kendra.model.ListDataSourcesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kendra.model.ListDataSourcesResponse =
      zio.aws.kendra.model.ListDataSourcesResponse(
        summaryItems.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def summaryItems
        : Optional[List[zio.aws.kendra.model.DataSourceSummary.ReadOnly]]
    def nextToken: Optional[NextToken]
    def getSummaryItems: ZIO[Any, AwsError, List[
      zio.aws.kendra.model.DataSourceSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("summaryItems", summaryItems)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kendra.model.ListDataSourcesResponse
  ) extends zio.aws.kendra.model.ListDataSourcesResponse.ReadOnly {
    override val summaryItems
        : Optional[List[zio.aws.kendra.model.DataSourceSummary.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.summaryItems())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.kendra.model.DataSourceSummary.wrap(item)
          }.toList
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.kendra.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kendra.model.ListDataSourcesResponse
  ): zio.aws.kendra.model.ListDataSourcesResponse.ReadOnly = new Wrapper(impl)
}
