package zio.aws.kendra.model
import zio.ZIO
import zio.aws.kendra.model.primitives.NextToken
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListFaqsResponse(
    nextToken: Optional[NextToken] = Optional.Absent,
    faqSummaryItems: Optional[Iterable[zio.aws.kendra.model.FaqSummary]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kendra.model.ListFaqsResponse = {
    import ListFaqsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kendra.model.ListFaqsResponse
      .builder()
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        faqSummaryItems.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.faqSummaryItems)
      .build()
  }
  def asReadOnly: zio.aws.kendra.model.ListFaqsResponse.ReadOnly =
    zio.aws.kendra.model.ListFaqsResponse.wrap(buildAwsValue())
}
object ListFaqsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kendra.model.ListFaqsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kendra.model.ListFaqsResponse =
      zio.aws.kendra.model.ListFaqsResponse(
        nextToken.map(value => value),
        faqSummaryItems.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextToken: Optional[NextToken]
    def faqSummaryItems
        : Optional[List[zio.aws.kendra.model.FaqSummary.ReadOnly]]
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getFaqSummaryItems
        : ZIO[Any, AwsError, List[zio.aws.kendra.model.FaqSummary.ReadOnly]] =
      AwsError.unwrapOptionField("faqSummaryItems", faqSummaryItems)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kendra.model.ListFaqsResponse
  ) extends zio.aws.kendra.model.ListFaqsResponse.ReadOnly {
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.kendra.model.primitives.NextToken(value))
    override val faqSummaryItems
        : Optional[List[zio.aws.kendra.model.FaqSummary.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.faqSummaryItems())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.kendra.model.FaqSummary.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.kendra.model.ListFaqsResponse
  ): zio.aws.kendra.model.ListFaqsResponse.ReadOnly = new Wrapper(impl)
}
