package zio.aws.kendra.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.kendra.model.primitives.{
  NextToken,
  PrincipalOrderingId,
  DataSourceId,
  IndexId,
  MaxResultsIntegerForListPrincipalsRequest
}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListGroupsOlderThanOrderingIdRequest(
    indexId: IndexId,
    dataSourceId: Optional[DataSourceId] = Optional.Absent,
    orderingId: PrincipalOrderingId,
    nextToken: Optional[NextToken] = Optional.Absent,
    maxResults: Optional[MaxResultsIntegerForListPrincipalsRequest] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kendra.model.ListGroupsOlderThanOrderingIdRequest = {
    import ListGroupsOlderThanOrderingIdRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kendra.model.ListGroupsOlderThanOrderingIdRequest
      .builder()
      .indexId(IndexId.unwrap(indexId): java.lang.String)
      .optionallyWith(
        dataSourceId.map(value => DataSourceId.unwrap(value): java.lang.String)
      )(_.dataSourceId)
      .orderingId(PrincipalOrderingId.unwrap(orderingId): java.lang.Long)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value =>
          MaxResultsIntegerForListPrincipalsRequest.unwrap(value): Integer
        )
      )(_.maxResults)
      .build()
  }
  def asReadOnly
      : zio.aws.kendra.model.ListGroupsOlderThanOrderingIdRequest.ReadOnly =
    zio.aws.kendra.model.ListGroupsOlderThanOrderingIdRequest
      .wrap(buildAwsValue())
}
object ListGroupsOlderThanOrderingIdRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kendra.model.ListGroupsOlderThanOrderingIdRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kendra.model.ListGroupsOlderThanOrderingIdRequest =
      zio.aws.kendra.model.ListGroupsOlderThanOrderingIdRequest(
        indexId,
        dataSourceId.map(value => value),
        orderingId,
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def indexId: IndexId
    def dataSourceId: Optional[DataSourceId]
    def orderingId: PrincipalOrderingId
    def nextToken: Optional[NextToken]
    def maxResults: Optional[MaxResultsIntegerForListPrincipalsRequest]
    def getIndexId: ZIO[Any, Nothing, IndexId] = ZIO.succeed(indexId)
    def getDataSourceId: ZIO[Any, AwsError, DataSourceId] =
      AwsError.unwrapOptionField("dataSourceId", dataSourceId)
    def getOrderingId: ZIO[Any, Nothing, PrincipalOrderingId] =
      ZIO.succeed(orderingId)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults
        : ZIO[Any, AwsError, MaxResultsIntegerForListPrincipalsRequest] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kendra.model.ListGroupsOlderThanOrderingIdRequest
  ) extends zio.aws.kendra.model.ListGroupsOlderThanOrderingIdRequest.ReadOnly {
    override val indexId: IndexId =
      zio.aws.kendra.model.primitives.IndexId(impl.indexId())
    override val dataSourceId: Optional[DataSourceId] = zio.aws.core.internal
      .optionalFromNullable(impl.dataSourceId())
      .map(value => zio.aws.kendra.model.primitives.DataSourceId(value))
    override val orderingId: PrincipalOrderingId =
      zio.aws.kendra.model.primitives.PrincipalOrderingId(impl.orderingId())
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.kendra.model.primitives.NextToken(value))
    override val maxResults
        : Optional[MaxResultsIntegerForListPrincipalsRequest] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value =>
          zio.aws.kendra.model.primitives
            .MaxResultsIntegerForListPrincipalsRequest(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.kendra.model.ListGroupsOlderThanOrderingIdRequest
  ): zio.aws.kendra.model.ListGroupsOlderThanOrderingIdRequest.ReadOnly =
    new Wrapper(impl)
}
