package zio.aws.kendra.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.kendra.model.primitives.{
  MaxResultsIntegerForListThesauriRequest,
  NextToken,
  IndexId
}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListThesauriRequest(
    indexId: IndexId,
    nextToken: Optional[NextToken] = Optional.Absent,
    maxResults: Optional[MaxResultsIntegerForListThesauriRequest] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kendra.model.ListThesauriRequest = {
    import ListThesauriRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kendra.model.ListThesauriRequest
      .builder()
      .indexId(IndexId.unwrap(indexId): java.lang.String)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value =>
          MaxResultsIntegerForListThesauriRequest.unwrap(value): Integer
        )
      )(_.maxResults)
      .build()
  }
  def asReadOnly: zio.aws.kendra.model.ListThesauriRequest.ReadOnly =
    zio.aws.kendra.model.ListThesauriRequest.wrap(buildAwsValue())
}
object ListThesauriRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kendra.model.ListThesauriRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kendra.model.ListThesauriRequest =
      zio.aws.kendra.model.ListThesauriRequest(
        indexId,
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def indexId: IndexId
    def nextToken: Optional[NextToken]
    def maxResults: Optional[MaxResultsIntegerForListThesauriRequest]
    def getIndexId: ZIO[Any, Nothing, IndexId] = ZIO.succeed(indexId)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults
        : ZIO[Any, AwsError, MaxResultsIntegerForListThesauriRequest] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kendra.model.ListThesauriRequest
  ) extends zio.aws.kendra.model.ListThesauriRequest.ReadOnly {
    override val indexId: IndexId =
      zio.aws.kendra.model.primitives.IndexId(impl.indexId())
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.kendra.model.primitives.NextToken(value))
    override val maxResults: Optional[MaxResultsIntegerForListThesauriRequest] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value =>
          zio.aws.kendra.model.primitives
            .MaxResultsIntegerForListThesauriRequest(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.kendra.model.ListThesauriRequest
  ): zio.aws.kendra.model.ListThesauriRequest.ReadOnly = new Wrapper(impl)
}
