package zio.aws.kendra.model
import scala.jdk.CollectionConverters._
sealed trait Mode {
  def unwrap: software.amazon.awssdk.services.kendra.model.Mode
}
object Mode {
  def wrap(
      value: software.amazon.awssdk.services.kendra.model.Mode
  ): zio.aws.kendra.model.Mode = value match {
    case software.amazon.awssdk.services.kendra.model.Mode.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.kendra.model.Mode.ENABLED =>
      val r = ENABLED
      r
    case software.amazon.awssdk.services.kendra.model.Mode.LEARN_ONLY =>
      val r = LEARN_ONLY
      r
  }
  case object unknownToSdkVersion extends zio.aws.kendra.model.Mode {
    override def unwrap: software.amazon.awssdk.services.kendra.model.Mode =
      software.amazon.awssdk.services.kendra.model.Mode.UNKNOWN_TO_SDK_VERSION
  }
  case object ENABLED extends zio.aws.kendra.model.Mode {
    override def unwrap: software.amazon.awssdk.services.kendra.model.Mode =
      software.amazon.awssdk.services.kendra.model.Mode.ENABLED
  }
  case object LEARN_ONLY extends zio.aws.kendra.model.Mode {
    override def unwrap: software.amazon.awssdk.services.kendra.model.Mode =
      software.amazon.awssdk.services.kendra.model.Mode.LEARN_ONLY
  }
}
