package zio.aws.kendra.model
import scala.jdk.CollectionConverters._
sealed trait Order {
  def unwrap: software.amazon.awssdk.services.kendra.model.Order
}
object Order {
  def wrap(
      value: software.amazon.awssdk.services.kendra.model.Order
  ): zio.aws.kendra.model.Order = value match {
    case software.amazon.awssdk.services.kendra.model.Order.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.kendra.model.Order.ASCENDING =>
      val r = ASCENDING
      r
    case software.amazon.awssdk.services.kendra.model.Order.DESCENDING =>
      val r = DESCENDING
      r
  }
  case object unknownToSdkVersion extends zio.aws.kendra.model.Order {
    override def unwrap: software.amazon.awssdk.services.kendra.model.Order =
      software.amazon.awssdk.services.kendra.model.Order.UNKNOWN_TO_SDK_VERSION
  }
  case object ASCENDING extends zio.aws.kendra.model.Order {
    override def unwrap: software.amazon.awssdk.services.kendra.model.Order =
      software.amazon.awssdk.services.kendra.model.Order.ASCENDING
  }
  case object DESCENDING extends zio.aws.kendra.model.Order {
    override def unwrap: software.amazon.awssdk.services.kendra.model.Order =
      software.amazon.awssdk.services.kendra.model.Order.DESCENDING
  }
}
