package zio.aws.kendra.model
import zio.ZIO
import zio.aws.kendra.model.primitives.{DataSourceId, PrincipalName}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class Principal(
    name: PrincipalName,
    `type`: zio.aws.kendra.model.PrincipalType,
    access: zio.aws.kendra.model.ReadAccessType,
    dataSourceId: Optional[DataSourceId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kendra.model.Principal = {
    import Principal.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kendra.model.Principal
      .builder()
      .name(PrincipalName.unwrap(name): java.lang.String)
      .`type`(`type`.unwrap)
      .access(access.unwrap)
      .optionallyWith(
        dataSourceId.map(value => DataSourceId.unwrap(value): java.lang.String)
      )(_.dataSourceId)
      .build()
  }
  def asReadOnly: zio.aws.kendra.model.Principal.ReadOnly =
    zio.aws.kendra.model.Principal.wrap(buildAwsValue())
}
object Principal {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.kendra.model.Principal] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kendra.model.Principal = zio.aws.kendra.model
      .Principal(name, `type`, access, dataSourceId.map(value => value))
    def name: PrincipalName
    def `type`: zio.aws.kendra.model.PrincipalType
    def access: zio.aws.kendra.model.ReadAccessType
    def dataSourceId: Optional[DataSourceId]
    def getName: ZIO[Any, Nothing, PrincipalName] = ZIO.succeed(name)
    def getType: ZIO[Any, Nothing, zio.aws.kendra.model.PrincipalType] =
      ZIO.succeed(`type`)
    def getAccess: ZIO[Any, Nothing, zio.aws.kendra.model.ReadAccessType] =
      ZIO.succeed(access)
    def getDataSourceId: ZIO[Any, AwsError, DataSourceId] =
      AwsError.unwrapOptionField("dataSourceId", dataSourceId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kendra.model.Principal
  ) extends zio.aws.kendra.model.Principal.ReadOnly {
    override val name: PrincipalName =
      zio.aws.kendra.model.primitives.PrincipalName(impl.name())
    override val `type`: zio.aws.kendra.model.PrincipalType =
      zio.aws.kendra.model.PrincipalType.wrap(impl.`type`())
    override val access: zio.aws.kendra.model.ReadAccessType =
      zio.aws.kendra.model.ReadAccessType.wrap(impl.access())
    override val dataSourceId: Optional[DataSourceId] = zio.aws.core.internal
      .optionalFromNullable(impl.dataSourceId())
      .map(value => zio.aws.kendra.model.primitives.DataSourceId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kendra.model.Principal
  ): zio.aws.kendra.model.Principal.ReadOnly = new Wrapper(impl)
}
