package zio.aws.kendra.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.kendra.model.primitives.{SecretArn, Port, Host}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ProxyConfiguration(
    host: Host,
    port: Port,
    credentials: Optional[SecretArn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kendra.model.ProxyConfiguration = {
    import ProxyConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kendra.model.ProxyConfiguration
      .builder()
      .host(Host.unwrap(host): java.lang.String)
      .port(Port.unwrap(port): Integer)
      .optionallyWith(
        credentials.map(value => SecretArn.unwrap(value): java.lang.String)
      )(_.credentials)
      .build()
  }
  def asReadOnly: zio.aws.kendra.model.ProxyConfiguration.ReadOnly =
    zio.aws.kendra.model.ProxyConfiguration.wrap(buildAwsValue())
}
object ProxyConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kendra.model.ProxyConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kendra.model.ProxyConfiguration =
      zio.aws.kendra.model
        .ProxyConfiguration(host, port, credentials.map(value => value))
    def host: Host
    def port: Port
    def credentials: Optional[SecretArn]
    def getHost: ZIO[Any, Nothing, Host] = ZIO.succeed(host)
    def getPort: ZIO[Any, Nothing, Port] = ZIO.succeed(port)
    def getCredentials: ZIO[Any, AwsError, SecretArn] =
      AwsError.unwrapOptionField("credentials", credentials)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kendra.model.ProxyConfiguration
  ) extends zio.aws.kendra.model.ProxyConfiguration.ReadOnly {
    override val host: Host = zio.aws.kendra.model.primitives.Host(impl.host())
    override val port: Port = zio.aws.kendra.model.primitives.Port(impl.port())
    override val credentials: Optional[SecretArn] = zio.aws.core.internal
      .optionalFromNullable(impl.credentials())
      .map(value => zio.aws.kendra.model.primitives.SecretArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kendra.model.ProxyConfiguration
  ): zio.aws.kendra.model.ProxyConfiguration.ReadOnly = new Wrapper(impl)
}
