package zio.aws.kendra.model
import zio.ZIO
import zio.aws.kendra.model.primitives.{
  QueryText,
  IndexId,
  Integer,
  DocumentAttributeKey,
  VisitorId
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class QueryRequest(
    indexId: IndexId,
    queryText: Optional[QueryText] = Optional.Absent,
    attributeFilter: Optional[zio.aws.kendra.model.AttributeFilter] =
      Optional.Absent,
    facets: Optional[Iterable[zio.aws.kendra.model.Facet]] = Optional.Absent,
    requestedDocumentAttributes: Optional[Iterable[DocumentAttributeKey]] =
      Optional.Absent,
    queryResultTypeFilter: Optional[zio.aws.kendra.model.QueryResultType] =
      Optional.Absent,
    documentRelevanceOverrideConfigurations: Optional[
      Iterable[zio.aws.kendra.model.DocumentRelevanceConfiguration]
    ] = Optional.Absent,
    pageNumber: Optional[Integer] = Optional.Absent,
    pageSize: Optional[Integer] = Optional.Absent,
    sortingConfiguration: Optional[zio.aws.kendra.model.SortingConfiguration] =
      Optional.Absent,
    userContext: Optional[zio.aws.kendra.model.UserContext] = Optional.Absent,
    visitorId: Optional[VisitorId] = Optional.Absent,
    spellCorrectionConfiguration: Optional[
      zio.aws.kendra.model.SpellCorrectionConfiguration
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kendra.model.QueryRequest = {
    import QueryRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kendra.model.QueryRequest
      .builder()
      .indexId(IndexId.unwrap(indexId): java.lang.String)
      .optionallyWith(
        queryText.map(value => QueryText.unwrap(value): java.lang.String)
      )(_.queryText)
      .optionallyWith(attributeFilter.map(value => value.buildAwsValue()))(
        _.attributeFilter
      )
      .optionallyWith(
        facets.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.facets)
      .optionallyWith(
        requestedDocumentAttributes.map(value =>
          value.map { item =>
            DocumentAttributeKey.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.requestedDocumentAttributes)
      .optionallyWith(queryResultTypeFilter.map(value => value.unwrap))(
        _.queryResultTypeFilter
      )
      .optionallyWith(
        documentRelevanceOverrideConfigurations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.documentRelevanceOverrideConfigurations)
      .optionallyWith(pageNumber.map(value => value: java.lang.Integer))(
        _.pageNumber
      )
      .optionallyWith(pageSize.map(value => value: java.lang.Integer))(
        _.pageSize
      )
      .optionallyWith(sortingConfiguration.map(value => value.buildAwsValue()))(
        _.sortingConfiguration
      )
      .optionallyWith(userContext.map(value => value.buildAwsValue()))(
        _.userContext
      )
      .optionallyWith(
        visitorId.map(value => VisitorId.unwrap(value): java.lang.String)
      )(_.visitorId)
      .optionallyWith(
        spellCorrectionConfiguration.map(value => value.buildAwsValue())
      )(_.spellCorrectionConfiguration)
      .build()
  }
  def asReadOnly: zio.aws.kendra.model.QueryRequest.ReadOnly =
    zio.aws.kendra.model.QueryRequest.wrap(buildAwsValue())
}
object QueryRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kendra.model.QueryRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kendra.model.QueryRequest =
      zio.aws.kendra.model.QueryRequest(
        indexId,
        queryText.map(value => value),
        attributeFilter.map(value => value.asEditable),
        facets.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        requestedDocumentAttributes.map(value => value),
        queryResultTypeFilter.map(value => value),
        documentRelevanceOverrideConfigurations.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        pageNumber.map(value => value),
        pageSize.map(value => value),
        sortingConfiguration.map(value => value.asEditable),
        userContext.map(value => value.asEditable),
        visitorId.map(value => value),
        spellCorrectionConfiguration.map(value => value.asEditable)
      )
    def indexId: IndexId
    def queryText: Optional[QueryText]
    def attributeFilter: Optional[zio.aws.kendra.model.AttributeFilter.ReadOnly]
    def facets: Optional[List[zio.aws.kendra.model.Facet.ReadOnly]]
    def requestedDocumentAttributes: Optional[List[DocumentAttributeKey]]
    def queryResultTypeFilter: Optional[zio.aws.kendra.model.QueryResultType]
    def documentRelevanceOverrideConfigurations: Optional[
      List[zio.aws.kendra.model.DocumentRelevanceConfiguration.ReadOnly]
    ]
    def pageNumber: Optional[Integer]
    def pageSize: Optional[Integer]
    def sortingConfiguration
        : Optional[zio.aws.kendra.model.SortingConfiguration.ReadOnly]
    def userContext: Optional[zio.aws.kendra.model.UserContext.ReadOnly]
    def visitorId: Optional[VisitorId]
    def spellCorrectionConfiguration
        : Optional[zio.aws.kendra.model.SpellCorrectionConfiguration.ReadOnly]
    def getIndexId: ZIO[Any, Nothing, IndexId] = ZIO.succeed(indexId)
    def getQueryText: ZIO[Any, AwsError, QueryText] =
      AwsError.unwrapOptionField("queryText", queryText)
    def getAttributeFilter
        : ZIO[Any, AwsError, zio.aws.kendra.model.AttributeFilter.ReadOnly] =
      AwsError.unwrapOptionField("attributeFilter", attributeFilter)
    def getFacets
        : ZIO[Any, AwsError, List[zio.aws.kendra.model.Facet.ReadOnly]] =
      AwsError.unwrapOptionField("facets", facets)
    def getRequestedDocumentAttributes
        : ZIO[Any, AwsError, List[DocumentAttributeKey]] =
      AwsError.unwrapOptionField(
        "requestedDocumentAttributes",
        requestedDocumentAttributes
      )
    def getQueryResultTypeFilter
        : ZIO[Any, AwsError, zio.aws.kendra.model.QueryResultType] =
      AwsError.unwrapOptionField("queryResultTypeFilter", queryResultTypeFilter)
    def getDocumentRelevanceOverrideConfigurations: ZIO[Any, AwsError, List[
      zio.aws.kendra.model.DocumentRelevanceConfiguration.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "documentRelevanceOverrideConfigurations",
      documentRelevanceOverrideConfigurations
    )
    def getPageNumber: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("pageNumber", pageNumber)
    def getPageSize: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("pageSize", pageSize)
    def getSortingConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.kendra.model.SortingConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("sortingConfiguration", sortingConfiguration)
    def getUserContext
        : ZIO[Any, AwsError, zio.aws.kendra.model.UserContext.ReadOnly] =
      AwsError.unwrapOptionField("userContext", userContext)
    def getVisitorId: ZIO[Any, AwsError, VisitorId] =
      AwsError.unwrapOptionField("visitorId", visitorId)
    def getSpellCorrectionConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.kendra.model.SpellCorrectionConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "spellCorrectionConfiguration",
      spellCorrectionConfiguration
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kendra.model.QueryRequest
  ) extends zio.aws.kendra.model.QueryRequest.ReadOnly {
    override val indexId: IndexId =
      zio.aws.kendra.model.primitives.IndexId(impl.indexId())
    override val queryText: Optional[QueryText] = zio.aws.core.internal
      .optionalFromNullable(impl.queryText())
      .map(value => zio.aws.kendra.model.primitives.QueryText(value))
    override val attributeFilter
        : Optional[zio.aws.kendra.model.AttributeFilter.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.attributeFilter())
        .map(value => zio.aws.kendra.model.AttributeFilter.wrap(value))
    override val facets: Optional[List[zio.aws.kendra.model.Facet.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.facets())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.kendra.model.Facet.wrap(item)
          }.toList
        )
    override val requestedDocumentAttributes
        : Optional[List[DocumentAttributeKey]] = zio.aws.core.internal
      .optionalFromNullable(impl.requestedDocumentAttributes())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.kendra.model.primitives.DocumentAttributeKey(item)
        }.toList
      )
    override val queryResultTypeFilter
        : Optional[zio.aws.kendra.model.QueryResultType] = zio.aws.core.internal
      .optionalFromNullable(impl.queryResultTypeFilter())
      .map(value => zio.aws.kendra.model.QueryResultType.wrap(value))
    override val documentRelevanceOverrideConfigurations: Optional[
      List[zio.aws.kendra.model.DocumentRelevanceConfiguration.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.documentRelevanceOverrideConfigurations())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.kendra.model.DocumentRelevanceConfiguration.wrap(item)
        }.toList
      )
    override val pageNumber: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.pageNumber())
      .map(value => value: Integer)
    override val pageSize: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.pageSize())
      .map(value => value: Integer)
    override val sortingConfiguration
        : Optional[zio.aws.kendra.model.SortingConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sortingConfiguration())
        .map(value => zio.aws.kendra.model.SortingConfiguration.wrap(value))
    override val userContext
        : Optional[zio.aws.kendra.model.UserContext.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.userContext())
        .map(value => zio.aws.kendra.model.UserContext.wrap(value))
    override val visitorId: Optional[VisitorId] = zio.aws.core.internal
      .optionalFromNullable(impl.visitorId())
      .map(value => zio.aws.kendra.model.primitives.VisitorId(value))
    override val spellCorrectionConfiguration
        : Optional[zio.aws.kendra.model.SpellCorrectionConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.spellCorrectionConfiguration())
        .map(value =>
          zio.aws.kendra.model.SpellCorrectionConfiguration.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.kendra.model.QueryRequest
  ): zio.aws.kendra.model.QueryRequest.ReadOnly = new Wrapper(impl)
}
