package zio.aws.kendra.model
import zio.ZIO
import zio.aws.kendra.model.primitives.{
  FeedbackToken,
  Url,
  DocumentId,
  ResultId
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class QueryResultItem(
    id: Optional[ResultId] = Optional.Absent,
    `type`: Optional[zio.aws.kendra.model.QueryResultType] = Optional.Absent,
    format: Optional[zio.aws.kendra.model.QueryResultFormat] = Optional.Absent,
    additionalAttributes: Optional[
      Iterable[zio.aws.kendra.model.AdditionalResultAttribute]
    ] = Optional.Absent,
    documentId: Optional[DocumentId] = Optional.Absent,
    documentTitle: Optional[zio.aws.kendra.model.TextWithHighlights] =
      Optional.Absent,
    documentExcerpt: Optional[zio.aws.kendra.model.TextWithHighlights] =
      Optional.Absent,
    documentURI: Optional[Url] = Optional.Absent,
    documentAttributes: Optional[
      Iterable[zio.aws.kendra.model.DocumentAttribute]
    ] = Optional.Absent,
    scoreAttributes: Optional[zio.aws.kendra.model.ScoreAttributes] =
      Optional.Absent,
    feedbackToken: Optional[FeedbackToken] = Optional.Absent,
    tableExcerpt: Optional[zio.aws.kendra.model.TableExcerpt] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kendra.model.QueryResultItem = {
    import QueryResultItem.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kendra.model.QueryResultItem
      .builder()
      .optionallyWith(
        id.map(value => ResultId.unwrap(value): java.lang.String)
      )(_.id)
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(format.map(value => value.unwrap))(_.format)
      .optionallyWith(
        additionalAttributes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.additionalAttributes)
      .optionallyWith(
        documentId.map(value => DocumentId.unwrap(value): java.lang.String)
      )(_.documentId)
      .optionallyWith(documentTitle.map(value => value.buildAwsValue()))(
        _.documentTitle
      )
      .optionallyWith(documentExcerpt.map(value => value.buildAwsValue()))(
        _.documentExcerpt
      )
      .optionallyWith(
        documentURI.map(value => Url.unwrap(value): java.lang.String)
      )(_.documentURI)
      .optionallyWith(
        documentAttributes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.documentAttributes)
      .optionallyWith(scoreAttributes.map(value => value.buildAwsValue()))(
        _.scoreAttributes
      )
      .optionallyWith(
        feedbackToken.map(value =>
          FeedbackToken.unwrap(value): java.lang.String
        )
      )(_.feedbackToken)
      .optionallyWith(tableExcerpt.map(value => value.buildAwsValue()))(
        _.tableExcerpt
      )
      .build()
  }
  def asReadOnly: zio.aws.kendra.model.QueryResultItem.ReadOnly =
    zio.aws.kendra.model.QueryResultItem.wrap(buildAwsValue())
}
object QueryResultItem {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kendra.model.QueryResultItem
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kendra.model.QueryResultItem =
      zio.aws.kendra.model.QueryResultItem(
        id.map(value => value),
        `type`.map(value => value),
        format.map(value => value),
        additionalAttributes.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        documentId.map(value => value),
        documentTitle.map(value => value.asEditable),
        documentExcerpt.map(value => value.asEditable),
        documentURI.map(value => value),
        documentAttributes.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        scoreAttributes.map(value => value.asEditable),
        feedbackToken.map(value => value),
        tableExcerpt.map(value => value.asEditable)
      )
    def id: Optional[ResultId]
    def `type`: Optional[zio.aws.kendra.model.QueryResultType]
    def format: Optional[zio.aws.kendra.model.QueryResultFormat]
    def additionalAttributes: Optional[
      List[zio.aws.kendra.model.AdditionalResultAttribute.ReadOnly]
    ]
    def documentId: Optional[DocumentId]
    def documentTitle
        : Optional[zio.aws.kendra.model.TextWithHighlights.ReadOnly]
    def documentExcerpt
        : Optional[zio.aws.kendra.model.TextWithHighlights.ReadOnly]
    def documentURI: Optional[Url]
    def documentAttributes
        : Optional[List[zio.aws.kendra.model.DocumentAttribute.ReadOnly]]
    def scoreAttributes: Optional[zio.aws.kendra.model.ScoreAttributes.ReadOnly]
    def feedbackToken: Optional[FeedbackToken]
    def tableExcerpt: Optional[zio.aws.kendra.model.TableExcerpt.ReadOnly]
    def getId: ZIO[Any, AwsError, ResultId] =
      AwsError.unwrapOptionField("id", id)
    def getType: ZIO[Any, AwsError, zio.aws.kendra.model.QueryResultType] =
      AwsError.unwrapOptionField("type", `type`)
    def getFormat: ZIO[Any, AwsError, zio.aws.kendra.model.QueryResultFormat] =
      AwsError.unwrapOptionField("format", format)
    def getAdditionalAttributes: ZIO[Any, AwsError, List[
      zio.aws.kendra.model.AdditionalResultAttribute.ReadOnly
    ]] =
      AwsError.unwrapOptionField("additionalAttributes", additionalAttributes)
    def getDocumentId: ZIO[Any, AwsError, DocumentId] =
      AwsError.unwrapOptionField("documentId", documentId)
    def getDocumentTitle
        : ZIO[Any, AwsError, zio.aws.kendra.model.TextWithHighlights.ReadOnly] =
      AwsError.unwrapOptionField("documentTitle", documentTitle)
    def getDocumentExcerpt
        : ZIO[Any, AwsError, zio.aws.kendra.model.TextWithHighlights.ReadOnly] =
      AwsError.unwrapOptionField("documentExcerpt", documentExcerpt)
    def getDocumentURI: ZIO[Any, AwsError, Url] =
      AwsError.unwrapOptionField("documentURI", documentURI)
    def getDocumentAttributes: ZIO[Any, AwsError, List[
      zio.aws.kendra.model.DocumentAttribute.ReadOnly
    ]] = AwsError.unwrapOptionField("documentAttributes", documentAttributes)
    def getScoreAttributes
        : ZIO[Any, AwsError, zio.aws.kendra.model.ScoreAttributes.ReadOnly] =
      AwsError.unwrapOptionField("scoreAttributes", scoreAttributes)
    def getFeedbackToken: ZIO[Any, AwsError, FeedbackToken] =
      AwsError.unwrapOptionField("feedbackToken", feedbackToken)
    def getTableExcerpt
        : ZIO[Any, AwsError, zio.aws.kendra.model.TableExcerpt.ReadOnly] =
      AwsError.unwrapOptionField("tableExcerpt", tableExcerpt)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kendra.model.QueryResultItem
  ) extends zio.aws.kendra.model.QueryResultItem.ReadOnly {
    override val id: Optional[ResultId] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value => zio.aws.kendra.model.primitives.ResultId(value))
    override val `type`: Optional[zio.aws.kendra.model.QueryResultType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.`type`())
        .map(value => zio.aws.kendra.model.QueryResultType.wrap(value))
    override val format: Optional[zio.aws.kendra.model.QueryResultFormat] =
      zio.aws.core.internal
        .optionalFromNullable(impl.format())
        .map(value => zio.aws.kendra.model.QueryResultFormat.wrap(value))
    override val additionalAttributes: Optional[
      List[zio.aws.kendra.model.AdditionalResultAttribute.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.additionalAttributes())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.kendra.model.AdditionalResultAttribute.wrap(item)
        }.toList
      )
    override val documentId: Optional[DocumentId] = zio.aws.core.internal
      .optionalFromNullable(impl.documentId())
      .map(value => zio.aws.kendra.model.primitives.DocumentId(value))
    override val documentTitle
        : Optional[zio.aws.kendra.model.TextWithHighlights.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.documentTitle())
        .map(value => zio.aws.kendra.model.TextWithHighlights.wrap(value))
    override val documentExcerpt
        : Optional[zio.aws.kendra.model.TextWithHighlights.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.documentExcerpt())
        .map(value => zio.aws.kendra.model.TextWithHighlights.wrap(value))
    override val documentURI: Optional[Url] = zio.aws.core.internal
      .optionalFromNullable(impl.documentURI())
      .map(value => zio.aws.kendra.model.primitives.Url(value))
    override val documentAttributes
        : Optional[List[zio.aws.kendra.model.DocumentAttribute.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.documentAttributes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.kendra.model.DocumentAttribute.wrap(item)
          }.toList
        )
    override val scoreAttributes
        : Optional[zio.aws.kendra.model.ScoreAttributes.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.scoreAttributes())
        .map(value => zio.aws.kendra.model.ScoreAttributes.wrap(value))
    override val feedbackToken: Optional[FeedbackToken] = zio.aws.core.internal
      .optionalFromNullable(impl.feedbackToken())
      .map(value => zio.aws.kendra.model.primitives.FeedbackToken(value))
    override val tableExcerpt
        : Optional[zio.aws.kendra.model.TableExcerpt.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tableExcerpt())
        .map(value => zio.aws.kendra.model.TableExcerpt.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kendra.model.QueryResultItem
  ): zio.aws.kendra.model.QueryResultItem.ReadOnly = new Wrapper(impl)
}
