package zio.aws.kendra.model
import zio.ZIO
import zio.aws.kendra.model.primitives.{
  DataSourceInclusionsExclusionsStringsMember,
  FolderId,
  SecretArn,
  Domain
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class QuipConfiguration(
    domain: Domain,
    secretArn: SecretArn,
    crawlFileComments: Optional[Boolean] = Optional.Absent,
    crawlChatRooms: Optional[Boolean] = Optional.Absent,
    crawlAttachments: Optional[Boolean] = Optional.Absent,
    folderIds: Optional[Iterable[FolderId]] = Optional.Absent,
    threadFieldMappings: Optional[
      Iterable[zio.aws.kendra.model.DataSourceToIndexFieldMapping]
    ] = Optional.Absent,
    messageFieldMappings: Optional[
      Iterable[zio.aws.kendra.model.DataSourceToIndexFieldMapping]
    ] = Optional.Absent,
    attachmentFieldMappings: Optional[
      Iterable[zio.aws.kendra.model.DataSourceToIndexFieldMapping]
    ] = Optional.Absent,
    inclusionPatterns: Optional[
      Iterable[DataSourceInclusionsExclusionsStringsMember]
    ] = Optional.Absent,
    exclusionPatterns: Optional[
      Iterable[DataSourceInclusionsExclusionsStringsMember]
    ] = Optional.Absent,
    vpcConfiguration: Optional[
      zio.aws.kendra.model.DataSourceVpcConfiguration
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kendra.model.QuipConfiguration = {
    import QuipConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kendra.model.QuipConfiguration
      .builder()
      .domain(Domain.unwrap(domain): java.lang.String)
      .secretArn(SecretArn.unwrap(secretArn): java.lang.String)
      .optionallyWith(crawlFileComments.map(value => value: java.lang.Boolean))(
        _.crawlFileComments
      )
      .optionallyWith(crawlChatRooms.map(value => value: java.lang.Boolean))(
        _.crawlChatRooms
      )
      .optionallyWith(crawlAttachments.map(value => value: java.lang.Boolean))(
        _.crawlAttachments
      )
      .optionallyWith(
        folderIds.map(value =>
          value.map { item =>
            FolderId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.folderIds)
      .optionallyWith(
        threadFieldMappings.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.threadFieldMappings)
      .optionallyWith(
        messageFieldMappings.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.messageFieldMappings)
      .optionallyWith(
        attachmentFieldMappings.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.attachmentFieldMappings)
      .optionallyWith(
        inclusionPatterns.map(value =>
          value.map { item =>
            DataSourceInclusionsExclusionsStringsMember.unwrap(
              item
            ): java.lang.String
          }.asJavaCollection
        )
      )(_.inclusionPatterns)
      .optionallyWith(
        exclusionPatterns.map(value =>
          value.map { item =>
            DataSourceInclusionsExclusionsStringsMember.unwrap(
              item
            ): java.lang.String
          }.asJavaCollection
        )
      )(_.exclusionPatterns)
      .optionallyWith(vpcConfiguration.map(value => value.buildAwsValue()))(
        _.vpcConfiguration
      )
      .build()
  }
  def asReadOnly: zio.aws.kendra.model.QuipConfiguration.ReadOnly =
    zio.aws.kendra.model.QuipConfiguration.wrap(buildAwsValue())
}
object QuipConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kendra.model.QuipConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kendra.model.QuipConfiguration =
      zio.aws.kendra.model.QuipConfiguration(
        domain,
        secretArn,
        crawlFileComments.map(value => value),
        crawlChatRooms.map(value => value),
        crawlAttachments.map(value => value),
        folderIds.map(value => value),
        threadFieldMappings.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        messageFieldMappings.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        attachmentFieldMappings.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        inclusionPatterns.map(value => value),
        exclusionPatterns.map(value => value),
        vpcConfiguration.map(value => value.asEditable)
      )
    def domain: Domain
    def secretArn: SecretArn
    def crawlFileComments: Optional[Boolean]
    def crawlChatRooms: Optional[Boolean]
    def crawlAttachments: Optional[Boolean]
    def folderIds: Optional[List[FolderId]]
    def threadFieldMappings: Optional[
      List[zio.aws.kendra.model.DataSourceToIndexFieldMapping.ReadOnly]
    ]
    def messageFieldMappings: Optional[
      List[zio.aws.kendra.model.DataSourceToIndexFieldMapping.ReadOnly]
    ]
    def attachmentFieldMappings: Optional[
      List[zio.aws.kendra.model.DataSourceToIndexFieldMapping.ReadOnly]
    ]
    def inclusionPatterns
        : Optional[List[DataSourceInclusionsExclusionsStringsMember]]
    def exclusionPatterns
        : Optional[List[DataSourceInclusionsExclusionsStringsMember]]
    def vpcConfiguration
        : Optional[zio.aws.kendra.model.DataSourceVpcConfiguration.ReadOnly]
    def getDomain: ZIO[Any, Nothing, Domain] = ZIO.succeed(domain)
    def getSecretArn: ZIO[Any, Nothing, SecretArn] = ZIO.succeed(secretArn)
    def getCrawlFileComments: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("crawlFileComments", crawlFileComments)
    def getCrawlChatRooms: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("crawlChatRooms", crawlChatRooms)
    def getCrawlAttachments: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("crawlAttachments", crawlAttachments)
    def getFolderIds: ZIO[Any, AwsError, List[FolderId]] =
      AwsError.unwrapOptionField("folderIds", folderIds)
    def getThreadFieldMappings: ZIO[Any, AwsError, List[
      zio.aws.kendra.model.DataSourceToIndexFieldMapping.ReadOnly
    ]] = AwsError.unwrapOptionField("threadFieldMappings", threadFieldMappings)
    def getMessageFieldMappings: ZIO[Any, AwsError, List[
      zio.aws.kendra.model.DataSourceToIndexFieldMapping.ReadOnly
    ]] =
      AwsError.unwrapOptionField("messageFieldMappings", messageFieldMappings)
    def getAttachmentFieldMappings: ZIO[Any, AwsError, List[
      zio.aws.kendra.model.DataSourceToIndexFieldMapping.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "attachmentFieldMappings",
      attachmentFieldMappings
    )
    def getInclusionPatterns: ZIO[Any, AwsError, List[
      DataSourceInclusionsExclusionsStringsMember
    ]] = AwsError.unwrapOptionField("inclusionPatterns", inclusionPatterns)
    def getExclusionPatterns: ZIO[Any, AwsError, List[
      DataSourceInclusionsExclusionsStringsMember
    ]] = AwsError.unwrapOptionField("exclusionPatterns", exclusionPatterns)
    def getVpcConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.kendra.model.DataSourceVpcConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("vpcConfiguration", vpcConfiguration)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kendra.model.QuipConfiguration
  ) extends zio.aws.kendra.model.QuipConfiguration.ReadOnly {
    override val domain: Domain =
      zio.aws.kendra.model.primitives.Domain(impl.domain())
    override val secretArn: SecretArn =
      zio.aws.kendra.model.primitives.SecretArn(impl.secretArn())
    override val crawlFileComments: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.crawlFileComments())
      .map(value => value: Boolean)
    override val crawlChatRooms: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.crawlChatRooms())
      .map(value => value: Boolean)
    override val crawlAttachments: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.crawlAttachments())
      .map(value => value: Boolean)
    override val folderIds: Optional[List[FolderId]] = zio.aws.core.internal
      .optionalFromNullable(impl.folderIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.kendra.model.primitives.FolderId(item)
        }.toList
      )
    override val threadFieldMappings: Optional[
      List[zio.aws.kendra.model.DataSourceToIndexFieldMapping.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.threadFieldMappings())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.kendra.model.DataSourceToIndexFieldMapping.wrap(item)
        }.toList
      )
    override val messageFieldMappings: Optional[
      List[zio.aws.kendra.model.DataSourceToIndexFieldMapping.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.messageFieldMappings())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.kendra.model.DataSourceToIndexFieldMapping.wrap(item)
        }.toList
      )
    override val attachmentFieldMappings: Optional[
      List[zio.aws.kendra.model.DataSourceToIndexFieldMapping.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.attachmentFieldMappings())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.kendra.model.DataSourceToIndexFieldMapping.wrap(item)
        }.toList
      )
    override val inclusionPatterns
        : Optional[List[DataSourceInclusionsExclusionsStringsMember]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.inclusionPatterns())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.kendra.model.primitives
              .DataSourceInclusionsExclusionsStringsMember(item)
          }.toList
        )
    override val exclusionPatterns
        : Optional[List[DataSourceInclusionsExclusionsStringsMember]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.exclusionPatterns())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.kendra.model.primitives
              .DataSourceInclusionsExclusionsStringsMember(item)
          }.toList
        )
    override val vpcConfiguration
        : Optional[zio.aws.kendra.model.DataSourceVpcConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.vpcConfiguration())
        .map(value =>
          zio.aws.kendra.model.DataSourceVpcConfiguration.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.kendra.model.QuipConfiguration
  ): zio.aws.kendra.model.QuipConfiguration.ReadOnly = new Wrapper(impl)
}
