package zio.aws.kendra.model
import zio.ZIO
import zio.aws.kendra.model.primitives.DataSourceFieldName
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class SalesforceStandardKnowledgeArticleTypeConfiguration(
    documentDataFieldName: DataSourceFieldName,
    documentTitleFieldName: Optional[DataSourceFieldName] = Optional.Absent,
    fieldMappings: Optional[
      Iterable[zio.aws.kendra.model.DataSourceToIndexFieldMapping]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kendra.model.SalesforceStandardKnowledgeArticleTypeConfiguration = {
    import SalesforceStandardKnowledgeArticleTypeConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kendra.model.SalesforceStandardKnowledgeArticleTypeConfiguration
      .builder()
      .documentDataFieldName(
        DataSourceFieldName.unwrap(documentDataFieldName): java.lang.String
      )
      .optionallyWith(
        documentTitleFieldName.map(value =>
          DataSourceFieldName.unwrap(value): java.lang.String
        )
      )(_.documentTitleFieldName)
      .optionallyWith(
        fieldMappings.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.fieldMappings)
      .build()
  }
  def asReadOnly
      : zio.aws.kendra.model.SalesforceStandardKnowledgeArticleTypeConfiguration.ReadOnly =
    zio.aws.kendra.model.SalesforceStandardKnowledgeArticleTypeConfiguration
      .wrap(buildAwsValue())
}
object SalesforceStandardKnowledgeArticleTypeConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kendra.model.SalesforceStandardKnowledgeArticleTypeConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.kendra.model.SalesforceStandardKnowledgeArticleTypeConfiguration =
      zio.aws.kendra.model.SalesforceStandardKnowledgeArticleTypeConfiguration(
        documentDataFieldName,
        documentTitleFieldName.map(value => value),
        fieldMappings.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def documentDataFieldName: DataSourceFieldName
    def documentTitleFieldName: Optional[DataSourceFieldName]
    def fieldMappings: Optional[
      List[zio.aws.kendra.model.DataSourceToIndexFieldMapping.ReadOnly]
    ]
    def getDocumentDataFieldName: ZIO[Any, Nothing, DataSourceFieldName] =
      ZIO.succeed(documentDataFieldName)
    def getDocumentTitleFieldName: ZIO[Any, AwsError, DataSourceFieldName] =
      AwsError.unwrapOptionField(
        "documentTitleFieldName",
        documentTitleFieldName
      )
    def getFieldMappings: ZIO[Any, AwsError, List[
      zio.aws.kendra.model.DataSourceToIndexFieldMapping.ReadOnly
    ]] = AwsError.unwrapOptionField("fieldMappings", fieldMappings)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kendra.model.SalesforceStandardKnowledgeArticleTypeConfiguration
  ) extends zio.aws.kendra.model.SalesforceStandardKnowledgeArticleTypeConfiguration.ReadOnly {
    override val documentDataFieldName: DataSourceFieldName =
      zio.aws.kendra.model.primitives
        .DataSourceFieldName(impl.documentDataFieldName())
    override val documentTitleFieldName: Optional[DataSourceFieldName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.documentTitleFieldName())
        .map(value =>
          zio.aws.kendra.model.primitives.DataSourceFieldName(value)
        )
    override val fieldMappings: Optional[
      List[zio.aws.kendra.model.DataSourceToIndexFieldMapping.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.fieldMappings())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.kendra.model.DataSourceToIndexFieldMapping.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.kendra.model.SalesforceStandardKnowledgeArticleTypeConfiguration
  ): zio.aws.kendra.model.SalesforceStandardKnowledgeArticleTypeConfiguration.ReadOnly =
    new Wrapper(impl)
}
