package zio.aws.kendra.model
import scala.jdk.CollectionConverters._
sealed trait ScoreConfidence {
  def unwrap: software.amazon.awssdk.services.kendra.model.ScoreConfidence
}
object ScoreConfidence {
  def wrap(
      value: software.amazon.awssdk.services.kendra.model.ScoreConfidence
  ): zio.aws.kendra.model.ScoreConfidence = value match {
    case software.amazon.awssdk.services.kendra.model.ScoreConfidence.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.kendra.model.ScoreConfidence.VERY_HIGH =>
      val r = VERY_HIGH
      r
    case software.amazon.awssdk.services.kendra.model.ScoreConfidence.HIGH =>
      val r = HIGH
      r
    case software.amazon.awssdk.services.kendra.model.ScoreConfidence.MEDIUM =>
      val r = MEDIUM
      r
    case software.amazon.awssdk.services.kendra.model.ScoreConfidence.LOW =>
      val r = LOW
      r
    case software.amazon.awssdk.services.kendra.model.ScoreConfidence.NOT_AVAILABLE =>
      val r = NOT_AVAILABLE
      r
  }
  case object unknownToSdkVersion extends zio.aws.kendra.model.ScoreConfidence {
    override def unwrap
        : software.amazon.awssdk.services.kendra.model.ScoreConfidence =
      software.amazon.awssdk.services.kendra.model.ScoreConfidence.UNKNOWN_TO_SDK_VERSION
  }
  case object VERY_HIGH extends zio.aws.kendra.model.ScoreConfidence {
    override def unwrap
        : software.amazon.awssdk.services.kendra.model.ScoreConfidence =
      software.amazon.awssdk.services.kendra.model.ScoreConfidence.VERY_HIGH
  }
  case object HIGH extends zio.aws.kendra.model.ScoreConfidence {
    override def unwrap
        : software.amazon.awssdk.services.kendra.model.ScoreConfidence =
      software.amazon.awssdk.services.kendra.model.ScoreConfidence.HIGH
  }
  case object MEDIUM extends zio.aws.kendra.model.ScoreConfidence {
    override def unwrap
        : software.amazon.awssdk.services.kendra.model.ScoreConfidence =
      software.amazon.awssdk.services.kendra.model.ScoreConfidence.MEDIUM
  }
  case object LOW extends zio.aws.kendra.model.ScoreConfidence {
    override def unwrap
        : software.amazon.awssdk.services.kendra.model.ScoreConfidence =
      software.amazon.awssdk.services.kendra.model.ScoreConfidence.LOW
  }
  case object NOT_AVAILABLE extends zio.aws.kendra.model.ScoreConfidence {
    override def unwrap
        : software.amazon.awssdk.services.kendra.model.ScoreConfidence =
      software.amazon.awssdk.services.kendra.model.ScoreConfidence.NOT_AVAILABLE
  }
}
