package zio.aws.kendra.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class Search(
    facetable: Optional[Boolean] = Optional.Absent,
    searchable: Optional[Boolean] = Optional.Absent,
    displayable: Optional[Boolean] = Optional.Absent,
    sortable: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.kendra.model.Search = {
    import Search.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kendra.model.Search
      .builder()
      .optionallyWith(facetable.map(value => value: java.lang.Boolean))(
        _.facetable
      )
      .optionallyWith(searchable.map(value => value: java.lang.Boolean))(
        _.searchable
      )
      .optionallyWith(displayable.map(value => value: java.lang.Boolean))(
        _.displayable
      )
      .optionallyWith(sortable.map(value => value: java.lang.Boolean))(
        _.sortable
      )
      .build()
  }
  def asReadOnly: zio.aws.kendra.model.Search.ReadOnly =
    zio.aws.kendra.model.Search.wrap(buildAwsValue())
}
object Search {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.kendra.model.Search] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kendra.model.Search = zio.aws.kendra.model.Search(
      facetable.map(value => value),
      searchable.map(value => value),
      displayable.map(value => value),
      sortable.map(value => value)
    )
    def facetable: Optional[Boolean]
    def searchable: Optional[Boolean]
    def displayable: Optional[Boolean]
    def sortable: Optional[Boolean]
    def getFacetable: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("facetable", facetable)
    def getSearchable: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("searchable", searchable)
    def getDisplayable: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("displayable", displayable)
    def getSortable: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("sortable", sortable)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kendra.model.Search
  ) extends zio.aws.kendra.model.Search.ReadOnly {
    override val facetable: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.facetable())
      .map(value => value: Boolean)
    override val searchable: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.searchable())
      .map(value => value: Boolean)
    override val displayable: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.displayable())
      .map(value => value: Boolean)
    override val sortable: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.sortable())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.kendra.model.Search
  ): zio.aws.kendra.model.Search.ReadOnly = new Wrapper(impl)
}
