package zio.aws.kendra.model
import zio.ZIO
import zio.aws.kendra.model.primitives.SeedUrl
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class SeedUrlConfiguration(
    seedUrls: Iterable[SeedUrl],
    webCrawlerMode: Optional[zio.aws.kendra.model.WebCrawlerMode] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kendra.model.SeedUrlConfiguration = {
    import SeedUrlConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kendra.model.SeedUrlConfiguration
      .builder()
      .seedUrls(seedUrls.map { item =>
        SeedUrl.unwrap(item): java.lang.String
      }.asJavaCollection)
      .optionallyWith(webCrawlerMode.map(value => value.unwrap))(
        _.webCrawlerMode
      )
      .build()
  }
  def asReadOnly: zio.aws.kendra.model.SeedUrlConfiguration.ReadOnly =
    zio.aws.kendra.model.SeedUrlConfiguration.wrap(buildAwsValue())
}
object SeedUrlConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kendra.model.SeedUrlConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kendra.model.SeedUrlConfiguration =
      zio.aws.kendra.model
        .SeedUrlConfiguration(seedUrls, webCrawlerMode.map(value => value))
    def seedUrls: List[SeedUrl]
    def webCrawlerMode: Optional[zio.aws.kendra.model.WebCrawlerMode]
    def getSeedUrls: ZIO[Any, Nothing, List[SeedUrl]] = ZIO.succeed(seedUrls)
    def getWebCrawlerMode
        : ZIO[Any, AwsError, zio.aws.kendra.model.WebCrawlerMode] =
      AwsError.unwrapOptionField("webCrawlerMode", webCrawlerMode)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kendra.model.SeedUrlConfiguration
  ) extends zio.aws.kendra.model.SeedUrlConfiguration.ReadOnly {
    override val seedUrls: List[SeedUrl] = impl
      .seedUrls()
      .asScala
      .map { item =>
        zio.aws.kendra.model.primitives.SeedUrl(item)
      }
      .toList
    override val webCrawlerMode: Optional[zio.aws.kendra.model.WebCrawlerMode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.webCrawlerMode())
        .map(value => zio.aws.kendra.model.WebCrawlerMode.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kendra.model.SeedUrlConfiguration
  ): zio.aws.kendra.model.SeedUrlConfiguration.ReadOnly = new Wrapper(impl)
}
