package zio.aws.kendra.model
import zio.ZIO
import zio.aws.kendra.model.primitives.KmsKeyId
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ServerSideEncryptionConfiguration(
    kmsKeyId: Optional[KmsKeyId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kendra.model.ServerSideEncryptionConfiguration = {
    import ServerSideEncryptionConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kendra.model.ServerSideEncryptionConfiguration
      .builder()
      .optionallyWith(
        kmsKeyId.map(value => KmsKeyId.unwrap(value): java.lang.String)
      )(_.kmsKeyId)
      .build()
  }
  def asReadOnly
      : zio.aws.kendra.model.ServerSideEncryptionConfiguration.ReadOnly =
    zio.aws.kendra.model.ServerSideEncryptionConfiguration.wrap(buildAwsValue())
}
object ServerSideEncryptionConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kendra.model.ServerSideEncryptionConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kendra.model.ServerSideEncryptionConfiguration =
      zio.aws.kendra.model
        .ServerSideEncryptionConfiguration(kmsKeyId.map(value => value))
    def kmsKeyId: Optional[KmsKeyId]
    def getKmsKeyId: ZIO[Any, AwsError, KmsKeyId] =
      AwsError.unwrapOptionField("kmsKeyId", kmsKeyId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kendra.model.ServerSideEncryptionConfiguration
  ) extends zio.aws.kendra.model.ServerSideEncryptionConfiguration.ReadOnly {
    override val kmsKeyId: Optional[KmsKeyId] = zio.aws.core.internal
      .optionalFromNullable(impl.kmsKeyId())
      .map(value => zio.aws.kendra.model.primitives.KmsKeyId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kendra.model.ServerSideEncryptionConfiguration
  ): zio.aws.kendra.model.ServerSideEncryptionConfiguration.ReadOnly =
    new Wrapper(impl)
}
