package zio.aws.kendra.model
import scala.jdk.CollectionConverters._
sealed trait SharePointOnlineAuthenticationType {
  def unwrap: software.amazon.awssdk.services.kendra.model.SharePointOnlineAuthenticationType
}
object SharePointOnlineAuthenticationType {
  def wrap(
      value: software.amazon.awssdk.services.kendra.model.SharePointOnlineAuthenticationType
  ): zio.aws.kendra.model.SharePointOnlineAuthenticationType = value match {
    case software.amazon.awssdk.services.kendra.model.SharePointOnlineAuthenticationType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.kendra.model.SharePointOnlineAuthenticationType.HTTP_BASIC =>
      val r = HTTP_BASIC
      r
    case software.amazon.awssdk.services.kendra.model.SharePointOnlineAuthenticationType.OAUTH2 =>
      val r = OAUTH2
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.kendra.model.SharePointOnlineAuthenticationType {
    override def unwrap
        : software.amazon.awssdk.services.kendra.model.SharePointOnlineAuthenticationType =
      software.amazon.awssdk.services.kendra.model.SharePointOnlineAuthenticationType.UNKNOWN_TO_SDK_VERSION
  }
  case object HTTP_BASIC
      extends zio.aws.kendra.model.SharePointOnlineAuthenticationType {
    override def unwrap
        : software.amazon.awssdk.services.kendra.model.SharePointOnlineAuthenticationType =
      software.amazon.awssdk.services.kendra.model.SharePointOnlineAuthenticationType.HTTP_BASIC
  }
  case object OAUTH2
      extends zio.aws.kendra.model.SharePointOnlineAuthenticationType {
    override def unwrap
        : software.amazon.awssdk.services.kendra.model.SharePointOnlineAuthenticationType =
      software.amazon.awssdk.services.kendra.model.SharePointOnlineAuthenticationType.OAUTH2
  }
}
