package zio.aws.kendra.model
import zio.ZIO
import zio.aws.kendra.model.primitives.SiteMap
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class SiteMapsConfiguration(siteMaps: Iterable[SiteMap]) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kendra.model.SiteMapsConfiguration = {
    import SiteMapsConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kendra.model.SiteMapsConfiguration
      .builder()
      .siteMaps(siteMaps.map { item =>
        SiteMap.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.kendra.model.SiteMapsConfiguration.ReadOnly =
    zio.aws.kendra.model.SiteMapsConfiguration.wrap(buildAwsValue())
}
object SiteMapsConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kendra.model.SiteMapsConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kendra.model.SiteMapsConfiguration =
      zio.aws.kendra.model.SiteMapsConfiguration(siteMaps)
    def siteMaps: List[SiteMap]
    def getSiteMaps: ZIO[Any, Nothing, List[SiteMap]] = ZIO.succeed(siteMaps)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kendra.model.SiteMapsConfiguration
  ) extends zio.aws.kendra.model.SiteMapsConfiguration.ReadOnly {
    override val siteMaps: List[SiteMap] = impl
      .siteMaps()
      .asScala
      .map { item =>
        zio.aws.kendra.model.primitives.SiteMap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.kendra.model.SiteMapsConfiguration
  ): zio.aws.kendra.model.SiteMapsConfiguration.ReadOnly = new Wrapper(impl)
}
